/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.config.service.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnSummary;
import org.hawkular.btm.api.model.config.btxn.ConfigMessage;
import org.hawkular.btm.api.services.ConfigurationLoader;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.api.utils.PropertyUtil;

public class ConfigurationServiceRESTClient
implements ConfigurationService {
    private static final Logger log = Logger.getLogger(ConfigurationServiceRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTxnSummary>> BTXN_SUMMARY_LIST = new TypeReference<List<BusinessTxnSummary>>(){};
    private static final TypeReference<Map<String, BusinessTxnConfig>> BUSINESS_TXN_MAP = new TypeReference<Map<String, BusinessTxnConfig>>(){};
    private static final TypeReference<List<ConfigMessage>> CONFIG_MESSAGE_LIST = new TypeReference<List<ConfigMessage>>(){};
    private static final String HAWKULAR_PERSONA = "Hawkular-Persona";
    private String username = PropertyUtil.getProperty("HAWKULAR_APM_USERNAME");
    private String password = PropertyUtil.getProperty("HAWKULAR_APM_PASSWORD");
    private String authorization = null;
    private String uri = PropertyUtil.getProperty("HAWKULAR_APM_URI");

    public ConfigurationServiceRESTClient() {
        if (this.uri != null && this.uri.length() > 0 && this.uri.charAt(this.uri.length() - 1) != '/') {
            this.uri = this.uri + '/';
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean isEnabled() {
        return this.uri != null && this.uri.startsWith("http");
    }

    @Override
    public CollectorConfiguration getCollector(String tenantId, String type, String host, String server) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get collector configuration: tenantId=[" + tenantId + "] type=[" + type + "] host=[" + host + "] server=[" + server + "]");
        }
        if (PropertyUtil.getProperty("HAWKULAR_APM_CONFIG") != null) {
            CollectorConfiguration ret = ConfigurationLoader.getConfiguration(type);
            if (log.isLoggable(Logger.Level.FINEST)) {
                try {
                    log.finest("Collector configuration [local] = " + (ret == null ? null : mapper.writeValueAsString(ret)));
                }
                catch (Throwable t) {
                    log.finest("Collector configuration [local]: failed to serialize as json: " + t);
                }
            }
            return ret;
        }
        if (!this.isEnabled()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/collector");
        if (host != null) {
            builder.append("?host=");
            builder.append(host);
        }
        if (server != null) {
            if (host == null) {
                builder.append('?');
            } else {
                builder.append('&');
            }
            builder.append("server=");
            builder.append(server);
        }
        if (type != null) {
            if (host == null && server == null) {
                builder.append('?');
            } else {
                builder.append('&');
            }
            builder.append("type=");
            builder.append(type);
        }
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                try {
                    CollectorConfiguration ret = mapper.readValue(resp.toString(), CollectorConfiguration.class);
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Collector configuration [remote] = " + (ret == null ? null : mapper.writeValueAsString(ret)));
                    }
                    return ret;
                }
                catch (Throwable t) {
                    log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get collector configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'get' collector configuration request", e);
        }
        return null;
    }

    @Override
    public List<ConfigMessage> setBusinessTransaction(String tenantId, String name, BusinessTxnConfig config) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Set busioess transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "] config=[" + config + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/businesstxn/full/").append(name);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes(config));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Set business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to set business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to set business transaction  [" + name + "] configuration", e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ConfigMessage> setBusinessTransactions(String tenantId, Map<String, BusinessTxnConfig> configs) throws Exception {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Set busioess transaction configurations: tenantId=[" + tenantId + "] configs=[" + configs + "]");
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/businesstxn/full");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes(configs));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Set business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to set business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to set business transaction configurations", e);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ConfigMessage> validateBusinessTransaction(BusinessTxnConfig config) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Validate busioess transaction configuration: config=[" + config + "]");
        }
        if (!this.isEnabled()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/businesstxn/validate");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, null);
            OutputStream os = connection.getOutputStream();
            os.write(mapper.writeValueAsBytes(config));
            os.flush();
            os.close();
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Validate business transaction configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CONFIG_MESSAGE_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else {
                log.severe("Failed to validate business transaction configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to validate business transaction configuration", e);
        }
        return Collections.emptyList();
    }

    @Override
    public BusinessTxnConfig getBusinessTransaction(String tenantId, String name) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "]");
        }
        if (!this.isEnabled()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/businesstxn/full/").append(name);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return mapper.readValue(resp.toString(), BusinessTxnConfig.class);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction [" + name + "] configuration", e);
        }
        return null;
    }

    @Override
    public List<BusinessTxnSummary> getBusinessTransactionSummaries(String tenantId) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction summaries: tenantId=[" + tenantId + "]");
        }
        if (!this.isEnabled()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/businesstxn/summary");
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), BTXN_SUMMARY_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction summaries: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction summaries", e);
        }
        return null;
    }

    @Override
    public Map<String, BusinessTxnConfig> getBusinessTransactions(String tenantId, long updated) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction configurations: tenantId=[" + tenantId + "] updated=[" + updated + "]");
        }
        if (!this.isEnabled()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return null;
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/businesstxn/full?updated=").append(updated);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (Map)mapper.readValue(resp.toString(), BUSINESS_TXN_MAP);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get business transaction configurations", e);
        }
        return null;
    }

    @Override
    public void removeBusinessTransaction(String tenantId, String name) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Update busioess transaction configuration: tenantId=[" + tenantId + "] name=[" + name + "]]");
        }
        if (!this.isEnabled()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return;
        }
        StringBuilder builder = new StringBuilder().append(this.uri).append("config/businesstxn/full/").append(name);
        try {
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            connection.getResponseCode();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Remove business transaction [" + name + "] configuration: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to remove business transaction  [" + name + "] configuration", e);
        }
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_PERSONA, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }

    @Override
    public void clear(String tenantId) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Clear business transaction configurations: tenantId=[" + tenantId + "]");
        }
        if (!this.isEnabled()) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Configuration Service is not enabled");
            }
            return;
        }
        try {
            URL url = new URL(this.getUri() + "config");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Business transaction configs cleared");
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to clear business transaction configurations: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'clear' business transaction config request", e);
        }
    }
}

