/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.instrumenter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.instrumentation.Instrumentation;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.api.services.ServiceResolver;
import org.hawkular.btm.client.api.TraceCollector;
import org.hawkular.btm.instrumenter.config.RuleTransformer;
import org.jboss.byteman.agent.Retransformer;

public class ClientManager {
    private static final Logger log = Logger.getLogger(ClientManager.class.getName());
    private static Retransformer transformer;
    private static RuleTransformer ruleTransformer;
    private static TraceCollector collector;
    private static ConfigurationService configService;

    public static void initialize(Retransformer trans) {
        CollectorConfiguration config;
        if (log.isLoggable(Logger.Level.FINER)) {
            log.finer("Initializing Client Manager");
        }
        transformer = trans;
        collector = ServiceResolver.getSingletonService(TraceCollector.class);
        if (log.isLoggable(Logger.Level.FINER)) {
            log.finer("Business Transaction Collector: " + collector);
        }
        configService = ServiceResolver.getSingletonService(ConfigurationService.class);
        if (log.isLoggable(Logger.Level.FINER)) {
            log.finer("Configuration Service: " + configService);
        }
        if ((config = configService.getCollector(null, null, null, null)) != null) {
            try {
                ClientManager.updateInstrumentation(config);
            }
            catch (Exception e) {
                System.err.println("Failed to update instrumentation rules: " + e);
                e.printStackTrace();
            }
        } else {
            log.severe("Unable to configure BTM");
        }
    }

    public static void updateInstrumentation(CollectorConfiguration config) throws Exception {
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<String> scriptNames = new ArrayList<String>();
        Map<String, Instrumentation> instrumentTypes = config.getInstrumentation();
        for (String name : instrumentTypes.keySet()) {
            Instrumentation types = instrumentTypes.get(name);
            String rules = ruleTransformer.transform(name, types, config.getProperty("version." + name, null));
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Update instrumentation script name=" + name + " rules=" + rules);
            }
            if (rules == null) continue;
            scriptNames.add(name);
            scripts.add(rules);
        }
        PrintWriter writer = new PrintWriter(new StringWriter());
        transformer.installScript(scripts, scriptNames, writer);
        writer.close();
    }

    static {
        ruleTransformer = new RuleTransformer();
    }
}

