/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.instrumenter.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.model.config.instrumentation.InstrumentAction;
import org.hawkular.btm.api.model.config.instrumentation.InstrumentBind;
import org.hawkular.btm.api.model.config.instrumentation.InstrumentRule;
import org.hawkular.btm.api.model.config.instrumentation.Instrumentation;
import org.hawkular.btm.api.services.ServiceResolver;
import org.hawkular.btm.instrumenter.RuleHelper;
import org.hawkular.btm.instrumenter.config.InstrumentActionTransformer;

public class RuleTransformer {
    private static Map<Class<? extends InstrumentAction>, InstrumentActionTransformer> transformers = new HashMap<Class<? extends InstrumentAction>, InstrumentActionTransformer>();

    public String transform(String name, Instrumentation types, String version) {
        StringBuilder builder = new StringBuilder();
        builder.append(types.isCompile() ? "COMPILE\r\n" : "NOCOMPILE\r\n");
        for (int ruleno = 0; ruleno < types.getRules().size(); ++ruleno) {
            int i;
            InstrumentRule rule = types.getRules().get(ruleno);
            if (!rule.isVersionValid(version)) continue;
            builder.append("\r\n");
            builder.append("RULE ");
            builder.append(name);
            builder.append('(');
            builder.append(ruleno + 1);
            builder.append(") ");
            builder.append(rule.getRuleName());
            builder.append("\r\n");
            if (rule.getClassName() != null) {
                builder.append("CLASS ");
                builder.append(rule.getClassName());
                builder.append("\r\n");
            } else if (rule.getInterfaceName() != null) {
                builder.append("INTERFACE ");
                builder.append(rule.getInterfaceName());
                builder.append("\r\n");
            }
            builder.append("METHOD ");
            builder.append(rule.getMethodName());
            if (rule.getParameterTypes().size() != 1 || !rule.getParameterTypes().get(0).equals("*")) {
                builder.append('(');
                for (i = 0; i < rule.getParameterTypes().size(); ++i) {
                    if (i > 0) {
                        builder.append(',');
                    }
                    builder.append(rule.getParameterTypes().get(i));
                }
                builder.append(')');
            }
            builder.append("\r\n");
            builder.append("HELPER ");
            if (rule.getHelper() == null) {
                builder.append(RuleHelper.class.getName());
            } else {
                builder.append(rule.getHelper());
            }
            builder.append("\r\n");
            builder.append("AT ");
            builder.append(rule.getLocation());
            builder.append("\r\n");
            if (rule.isCompile() != types.isCompile()) {
                builder.append(rule.isCompile() ? "COMPILE\r\n" : "NOCOMPILE\r\n");
            }
            if (!rule.getBinds().isEmpty()) {
                builder.append("BIND ");
                for (i = 0; i < rule.getBinds().size(); ++i) {
                    InstrumentBind bind = rule.getBinds().get(i);
                    if (i > 0) {
                        builder.append("     ");
                    }
                    builder.append(bind.getName());
                    builder.append(" : ");
                    builder.append(bind.getType());
                    builder.append(" = ");
                    builder.append(bind.getExpression());
                    builder.append(";\r\n");
                }
            }
            builder.append("IF ");
            if (rule.getCondition() == null) {
                builder.append("TRUE");
            } else {
                builder.append(rule.getCondition());
            }
            builder.append("\r\n");
            builder.append("DO\r\n");
            for (i = 0; i < rule.getActions().size(); ++i) {
                InstrumentAction action = rule.getActions().get(i);
                builder.append("  ");
                InstrumentActionTransformer transformer = transformers.get(action.getClass());
                if (transformer != null) {
                    builder.append(transformer.convertToRuleAction(rule.getActions().get(i)));
                    if (i < rule.getActions().size() - 1) {
                        builder.append(";");
                    }
                    builder.append("\r\n");
                    continue;
                }
                System.err.println("Transformer for action '" + action.getClass() + "' not found");
            }
            builder.append("ENDRULE\r\n\r\n");
        }
        return builder.toString();
    }

    static {
        List<InstrumentActionTransformer> trms = ServiceResolver.getServices(InstrumentActionTransformer.class);
        trms.forEach(t -> transformers.put(t.getActionType(), (InstrumentActionTransformer)t));
    }
}

