/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.instrumenter.headers;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.client.api.HeadersAccessor;

public class ApacheHttpclientHeadersAccessor
implements HeadersAccessor {
    private static final Logger log = Logger.getLogger(ApacheHttpclientHeadersAccessor.class.getName());
    private static final String TARGET_TYPE = "org.apache.http.HttpMessage";

    @Override
    public String getTargetType() {
        return TARGET_TYPE;
    }

    @Override
    public Map<String, String> getHeaders(Object target) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(TARGET_TYPE);
            Class<?> headercls = Thread.currentThread().getContextClassLoader().loadClass("org.apache.http.Header");
            Method getHeaderNamesMethod = cls.getMethod("headerIterator", new Class[0]);
            Method getNameMethod = headercls.getMethod("getName", new Class[0]);
            Method getValueMethod = headercls.getMethod("getValue", new Class[0]);
            HashMap<String, String> ret = new HashMap<String, String>();
            Iterator iter = (Iterator)getHeaderNamesMethod.invoke(target, new Object[0]);
            while (iter.hasNext()) {
                Object header = iter.next();
                String name = (String)getNameMethod.invoke(header, new Object[0]);
                String value = (String)getValueMethod.invoke(header, new Object[0]);
                ret.put(name, value);
            }
            return ret;
        }
        catch (Throwable t) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.log(Logger.Level.FINEST, "Failed to obtain headers", t);
            }
            return null;
        }
    }
}

