/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.instrumenter.headers;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.client.api.HeadersAccessor;

public class JavaxServletHeadersAccessor
implements HeadersAccessor {
    private static final Logger log = Logger.getLogger(JavaxServletHeadersAccessor.class.getName());
    private static final String TARGET_TYPE = "javax.servlet.http.HttpServletRequest";

    @Override
    public String getTargetType() {
        return TARGET_TYPE;
    }

    @Override
    public Map<String, String> getHeaders(Object target) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(TARGET_TYPE);
            Method getHeaderNamesMethod = cls.getMethod("getHeaderNames", new Class[0]);
            Method getHeaderMethod = cls.getMethod("getHeader", String.class);
            HashMap<String, String> ret = new HashMap<String, String>();
            Enumeration iter = (Enumeration)getHeaderNamesMethod.invoke(target, new Object[0]);
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                String value = (String)getHeaderMethod.invoke(target, key);
                ret.put(key, value);
            }
            return ret;
        }
        catch (Throwable t) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.log(Logger.Level.FINEST, "Failed to obtain headers", t);
            }
            return null;
        }
    }
}

