/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.analytics.service.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.analytics.Cardinality;
import org.hawkular.btm.api.model.analytics.CompletionTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.NodeSummaryStatistics;
import org.hawkular.btm.api.model.analytics.NodeTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.Percentiles;
import org.hawkular.btm.api.model.analytics.PropertyInfo;
import org.hawkular.btm.api.model.analytics.URIInfo;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.api.model.events.NodeDetails;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.api.services.BaseCriteria;
import org.hawkular.btm.api.services.CompletionTimeCriteria;
import org.hawkular.btm.api.services.NodeCriteria;

public class AnalyticsServiceRESTClient
implements AnalyticsService {
    private static final Logger log = Logger.getLogger((String)AnalyticsServiceRESTClient.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<URIInfo>> URIINFO_LIST = new TypeReference<List<URIInfo>>(){};
    private static final TypeReference<List<String>> STRING_LIST = new TypeReference<List<String>>(){};
    private static final TypeReference<List<CompletionTimeseriesStatistics>> COMPLETION_STATISTICS_LIST = new TypeReference<List<CompletionTimeseriesStatistics>>(){};
    private static final TypeReference<List<NodeTimeseriesStatistics>> NODE_TIMESERIES_STATISTICS_LIST = new TypeReference<List<NodeTimeseriesStatistics>>(){};
    private static final TypeReference<List<NodeSummaryStatistics>> NODE_SUMMARY_STATISTICS_LIST = new TypeReference<List<NodeSummaryStatistics>>(){};
    private static final TypeReference<List<Cardinality>> CARDINALITY_LIST = new TypeReference<List<Cardinality>>(){};
    private static final TypeReference<List<PropertyInfo>> PROPERTY_INFO_LIST = new TypeReference<List<PropertyInfo>>(){};
    private static final String HAWKULAR_PERSONA = "Hawkular-Persona";
    private String username = System.getProperty("hawkular-btm.username");
    private String password = System.getProperty("hawkular-btm.password");
    private String authorization = null;
    private String baseUrl = System.getProperty("hawkular-btm.base-uri");

    public AnalyticsServiceRESTClient() {
        if (this.baseUrl != null && this.baseUrl.length() > 0 && this.baseUrl.charAt(this.baseUrl.length() - 1) != '/') {
            this.baseUrl = this.baseUrl + '/';
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.authorization = null;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.authorization = null;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public List<URIInfo> getUnboundURIs(String tenantId, long startTime, long endTime, boolean compress) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get unbound URIs: tenantId=[" + tenantId + "] startTime=" + startTime + " endTime=" + endTime + " compress=" + compress);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/unbounduris?startTime=").append(startTime).append("&endTime=").append(endTime).append("&compress=").append(compress);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), URIINFO_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get unbound URIs: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get unbound URIs", (Throwable)e);
        }
        return null;
    }

    public List<String> getBoundURIs(String tenantId, String businessTransaction, long startTime, long endTime) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get bound URIs: tenantId=[" + tenantId + "] businessTransaction=" + businessTransaction + " startTime=" + startTime + " endTime=" + endTime);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/bounduris/").append(businessTransaction).append("?startTime=").append(startTime).append("&endTime=").append(endTime);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), STRING_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get unbound URIs: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get unbound URIs", (Throwable)e);
        }
        return null;
    }

    public List<PropertyInfo> getPropertyInfo(String tenantId, String businessTransaction, long startTime, long endTime) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get property info: tenantId=[" + tenantId + "] businessTransaction=" + businessTransaction + " startTime=" + startTime + " endTime=" + endTime);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/properties/").append(businessTransaction).append("?startTime=").append(startTime).append("&endTime=").append(endTime);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), PROPERTY_INFO_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get property info: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get property info", (Throwable)e);
        }
        return null;
    }

    public long getCompletionCount(String tenantId, CompletionTimeCriteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion count: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/completion/count");
        this.buildQueryString(builder, (BaseCriteria)criteria);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return Long.parseLong(resp.toString());
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get completion count: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get completion count", (Throwable)e);
        }
        return 0L;
    }

    public long getCompletionFaultCount(String tenantId, CompletionTimeCriteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion fault count: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/completion/faultcount");
        this.buildQueryString(builder, (BaseCriteria)criteria);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return Long.parseLong(resp.toString());
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get completion fault count: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get completion fault count", (Throwable)e);
        }
        return 0L;
    }

    public Percentiles getCompletionPercentiles(String tenantId, CompletionTimeCriteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion percentiles: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/completion/percentiles");
        this.buildQueryString(builder, (BaseCriteria)criteria);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (Percentiles)mapper.readValue(resp.toString(), Percentiles.class);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get completion percentiles: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get completion percentiles", (Throwable)e);
        }
        return null;
    }

    public List<CompletionTimeseriesStatistics> getCompletionTimeseriesStatistics(String tenantId, CompletionTimeCriteria criteria, long interval) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion statistics: tenantId=[" + tenantId + "] criteria=" + criteria + " interval=" + interval);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/completion/statistics");
        this.buildQueryString(builder, (BaseCriteria)criteria);
        builder.append("&interval=");
        builder.append(interval);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), COMPLETION_STATISTICS_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get completion statistics: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get completion statistics", (Throwable)e);
        }
        return null;
    }

    public List<Cardinality> getCompletionFaultDetails(String tenantId, CompletionTimeCriteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion fault details: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/completion/faults");
        this.buildQueryString(builder, (BaseCriteria)criteria);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CARDINALITY_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get completion fault details: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get completion fault details", (Throwable)e);
        }
        return null;
    }

    public List<Cardinality> getCompletionPropertyDetails(String tenantId, CompletionTimeCriteria criteria, String property) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get completion property details: tenantId=[" + tenantId + "] criteria=" + criteria + " property=" + property);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/completion/property/").append(property);
        this.buildQueryString(builder, (BaseCriteria)criteria);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), CARDINALITY_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get completion property details: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get completion property details", (Throwable)e);
        }
        return null;
    }

    protected boolean buildQueryString(StringBuilder builder, BaseCriteria criteria) {
        Map queryParams = criteria.parameters();
        if (!queryParams.isEmpty()) {
            builder.append('?');
            boolean first = true;
            for (String key : queryParams.keySet()) {
                if (!first) {
                    builder.append('&');
                }
                String value = (String)queryParams.get(key);
                builder.append(key);
                builder.append('=');
                builder.append(value);
                first = false;
            }
            return true;
        }
        return false;
    }

    public int getAlertCount(String tenantId, String name) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get alert count: tenantId=[" + tenantId + "] name=" + name);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/alerts/count/").append(name);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return Integer.parseInt(resp.toString());
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get alert count: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get alert count", (Throwable)e);
        }
        return 0;
    }

    public List<NodeTimeseriesStatistics> getNodeTimeseriesStatistics(String tenantId, NodeCriteria criteria, long interval) {
        StringBuilder builder;
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get node timeseries statistics: tenantId=[" + tenantId + "] criteria=" + criteria + " interval=" + interval);
        }
        if (this.buildQueryString(builder = new StringBuilder().append(this.baseUrl).append("analytics/node/statistics"), (BaseCriteria)criteria)) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        builder.append("interval=");
        builder.append(interval);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), NODE_TIMESERIES_STATISTICS_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get node timeseries statistics: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get node timeseries statistics", (Throwable)e);
        }
        return null;
    }

    public List<NodeSummaryStatistics> getNodeSummaryStatistics(String tenantId, NodeCriteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get node summary statistics: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/node/summary");
        this.buildQueryString(builder, (BaseCriteria)criteria);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), NODE_SUMMARY_STATISTICS_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get node summary statistics: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get node summary statistics", (Throwable)e);
        }
        return null;
    }

    protected void addHeaders(HttpURLConnection connection, String tenantId) {
        if (tenantId != null) {
            connection.setRequestProperty(HAWKULAR_PERSONA, tenantId);
        }
        if (this.authorization == null && this.username != null) {
            String authString = this.username + ":" + this.password;
            String encoded = Base64.getEncoder().encodeToString(authString.getBytes());
            this.authorization = "Basic " + encoded;
        }
        if (this.authorization != null) {
            connection.setRequestProperty("Authorization", this.authorization);
        }
    }

    public void storeNodeDetails(String tenantId, List<NodeDetails> nodeDetails) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void storeCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<String> getHostNames(String tenantId, BaseCriteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get host names: tenantId=[" + tenantId + "] criteria=" + criteria);
        }
        StringBuilder builder = new StringBuilder().append(this.baseUrl).append("analytics/hostnames");
        this.buildQueryString(builder, criteria);
        try {
            int len;
            URL url = new URL(builder.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            StringBuilder resp = new StringBuilder();
            byte[] b = new byte[10000];
            while ((len = is.read(b)) != -1) {
                resp.append(new String(b, 0, len));
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + resp.toString() + "]");
                }
                if (resp.toString().trim().length() > 0) {
                    try {
                        return (List)mapper.readValue(resp.toString(), STRING_LIST);
                    }
                    catch (Throwable t) {
                        log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                    }
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get host names: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to get host names", (Throwable)e);
        }
        return null;
    }
}

