/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.btxn;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.wordnik.swagger.annotations.ApiModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.btm.api.model.btxn.Component;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.btxn.Service;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Consumer.class), @JsonSubTypes.Type(value=Producer.class), @JsonSubTypes.Type(value=Service.class), @JsonSubTypes.Type(value=Component.class)})
@ApiModel(subTypes={Consumer.class, Producer.class, Service.class, Component.class}, discriminator="type")
public abstract class Node {
    @JsonInclude
    private String uri;
    @JsonInclude
    private long startTime = 0L;
    @JsonInclude
    private long duration = 0L;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> details = new HashMap<String, String>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Set<CorrelationIdentifier> correlationIds = new HashSet<CorrelationIdentifier>();

    public Node() {
    }

    public Node(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public Set<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public void setCorrelationIds(Set<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
    }

    public void addInteractionId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
    }

    public void addGlobalId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Global, id));
    }

    public void addLocalId(String id) {
        this.correlationIds.add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Local, id));
    }

    public long endTime() {
        long ret = 0L;
        if (this.startTime > 0L) {
            ret = this.startTime + this.duration;
        }
        return ret;
    }

    protected long overallEndTime() {
        return this.endTime();
    }

    protected void findCorrelatedNodes(CorrelationIdentifier cid, long baseTime, Set<Node> nodes) {
        if (this.isCorrelated(cid, baseTime)) {
            nodes.add(this);
        }
    }

    protected boolean isCorrelated(CorrelationIdentifier cid, long baseTime) {
        for (CorrelationIdentifier id : this.correlationIds) {
            if (!id.match(this.startTime, cid, baseTime)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationIds == null ? 0 : this.correlationIds.hashCode());
        result = 31 * result + (this.details == null ? 0 : this.details.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.correlationIds == null ? other.correlationIds != null : !this.correlationIds.equals(other.correlationIds)) {
            return false;
        }
        if (this.details == null ? other.details != null : !this.details.equals(other.details)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.startTime != other.startTime) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

