/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.client;

public class Logger {
    private static Level level = Level.valueOf(System.getProperty("hawkular-btm.log.level", Level.INFO.name()));
    private String className;
    private String simpleClassName = null;

    protected Logger(String className) {
        this.className = className;
        int index = className.lastIndexOf(46);
        if (index != -1) {
            this.simpleClassName = className.substring(index + 1);
        }
    }

    public static Logger getLogger(String className) {
        return new Logger(className);
    }

    public boolean isLoggable(Level l) {
        return l.ordinal() >= level.ordinal();
    }

    public void finest(String mesg) {
        this.log(Level.FINEST, mesg, null);
    }

    public void finer(String mesg) {
        this.log(Level.FINER, mesg, null);
    }

    public void fine(String mesg) {
        this.log(Level.FINE, mesg, null);
    }

    public void info(String mesg) {
        this.log(Level.INFO, mesg, null);
    }

    public void warning(String mesg) {
        this.log(Level.WARNING, mesg, null);
    }

    public void severe(String mesg) {
        this.log(Level.SEVERE, mesg, null);
    }

    public void log(Level mesgLevel, String mesg, Throwable t) {
        if (mesgLevel.ordinal() >= level.ordinal()) {
            StringBuilder builder = new StringBuilder();
            builder.append(mesgLevel.name());
            builder.append(": [");
            builder.append(this.simpleClassName != null ? this.simpleClassName : this.className);
            builder.append("] [");
            builder.append(Thread.currentThread());
            builder.append("] ");
            builder.append(mesg);
            if (mesgLevel == Level.SEVERE) {
                System.err.println(builder.toString());
            } else {
                System.out.println(builder.toString());
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static enum Level {
        FINEST,
        FINER,
        FINE,
        INFO,
        WARNING,
        SEVERE;

    }
}

