/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;

public class BusinessTransactionCriteria {
    private final Logger log = Logger.getLogger(BusinessTransactionCriteria.class.getName());
    private long startTime = 0L;
    private long endTime = 0L;
    private Map<String, String> properties = new HashMap<String, String>();
    private Set<CorrelationIdentifier> correlationIds = new HashSet<CorrelationIdentifier>();

    public long getStartTime() {
        return this.startTime;
    }

    public BusinessTransactionCriteria setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public BusinessTransactionCriteria setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public BusinessTransactionCriteria setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Set<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public BusinessTransactionCriteria setCorrelationIds(Set<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
        return this;
    }

    public boolean isValid(BusinessTransaction btxn) {
        if (this.startTime > 0L && btxn.getStartTime() < this.startTime) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Start time out of range");
            }
            return false;
        }
        if (this.endTime > 0L && btxn.getStartTime() > this.endTime) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("End time out of range");
            }
            return false;
        }
        if (!this.properties.isEmpty()) {
            for (String key : this.properties.keySet()) {
                String value = this.properties.get(key);
                String result = btxn.getProperties().get(key);
                if (result != null && value.equals(result)) continue;
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Property '" + key + "' had value '" + result + "', expected '" + value + "'");
                }
                return false;
            }
        }
        if (!this.correlationIds.isEmpty()) {
            for (CorrelationIdentifier ci : this.correlationIds) {
                Set<Node> nodes = btxn.getCorrelatedNodes(ci);
                if (nodes.isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "BusinessTransactionCriteria [startTime=" + this.startTime + ", endTime=" + this.endTime + ", properties=" + this.properties + ", correlationIds=" + this.correlationIds + "]";
    }
}

