/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.model.analytics.URIInfo;
import org.hawkular.btm.api.services.AnalyticsService;

public abstract class AbstractAnalyticsService
implements AnalyticsService {
    protected static List<URIInfo> compressURIInfo(List<URIInfo> uris) {
        ArrayList<URIInfo> others = new ArrayList<URIInfo>();
        URIPart rootPart = new URIPart();
        for (int i = 0; i < uris.size(); ++i) {
            URIInfo uri = uris.get(i);
            if (uri.getUri() != null && uri.getUri().length() > 0 && uri.getUri().charAt(0) == '/') {
                String[] parts = uri.getUri().split("/");
                AbstractAnalyticsService.buildTree(rootPart, parts, 1, uri.getEndpointType());
                continue;
            }
            others.add(uri);
        }
        if (others.size() == uris.size()) {
            return uris;
        }
        rootPart.collapse();
        List<URIInfo> info = AbstractAnalyticsService.extractURIInfo(rootPart);
        AbstractAnalyticsService.initURIInfo(info);
        return info;
    }

    protected static void buildTree(URIPart parent, String[] parts, int index, String endpointType) {
        URIPart child = parent.addChild(parts[index]);
        if (index < parts.length - 1) {
            AbstractAnalyticsService.buildTree(child, parts, index + 1, endpointType);
        } else {
            child.setEndpointType(endpointType);
        }
    }

    protected static List<URIInfo> extractURIInfo(URIPart root) {
        ArrayList<URIInfo> uris = new ArrayList<URIInfo>();
        root.extractURIInfo(uris, "");
        return uris;
    }

    protected static void initURIInfo(List<URIInfo> uris) {
        for (int i = 0; i < uris.size(); ++i) {
            URIInfo info = uris.get(i);
            info.setRegex(AbstractAnalyticsService.createRegex(info.getUri(), info.metaURI()));
            if (!info.metaURI()) continue;
            StringBuilder template = new StringBuilder();
            String[] parts = info.getUri().split("/");
            String part = null;
            int paramNo = 1;
            for (int j = 1; j < parts.length; ++j) {
                template.append("/");
                if (parts[j].equals("*")) {
                    if (part == null) {
                        template.append("{");
                        template.append("param");
                        template.append(paramNo++);
                        template.append("}");
                    } else {
                        if (part.length() > 1 && part.charAt(part.length() - 1) == 's') {
                            part = part.substring(0, part.length() - 1);
                        }
                        template.append("{");
                        template.append(part);
                        template.append("Id}");
                    }
                    part = null;
                    continue;
                }
                part = parts[j];
                template.append(part);
            }
            info.setTemplate(template.toString());
        }
    }

    protected static String createRegex(String uri, boolean meta) {
        String regex = "^" + uri.replaceAll("/", "\\\\/") + "$";
        if (meta) {
            regex = regex.replaceAll("\\*", ".*");
        }
        return regex;
    }

    public static class URIPart {
        private static final int CHILD_THRESHOLD = 10;
        private int count = 1;
        private Map<String, URIPart> children;
        private String endpointType;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public Map<String, URIPart> getChildren() {
            return this.children;
        }

        public void setChildren(Map<String, URIPart> children) {
            this.children = children;
        }

        public URIPart addChild(String name) {
            URIPart child = null;
            if (this.children == null) {
                this.children = new HashMap<String, URIPart>();
            }
            if (!this.children.containsKey(name)) {
                child = new URIPart();
                this.children.put(name, child);
            } else {
                child = this.children.get(name);
                child.setCount(child.getCount() + 1);
            }
            return child;
        }

        public void collapse() {
            if (this.children != null && !this.children.isEmpty()) {
                if (this.children.size() >= 10) {
                    URIPart merged = new URIPart();
                    for (URIPart cur : this.children.values()) {
                        merged.merge(cur);
                    }
                    this.children.clear();
                    this.children.put("*", merged);
                    merged.collapse();
                } else {
                    for (URIPart part : this.children.values()) {
                        part.collapse();
                    }
                }
            }
        }

        public void merge(URIPart toMerge) {
            if (this.endpointType == null) {
                this.endpointType = toMerge.getEndpointType();
            }
            this.count += toMerge.getCount();
            if (toMerge.getChildren() != null) {
                if (this.children == null) {
                    this.children = new HashMap<String, URIPart>();
                }
                for (String child : toMerge.getChildren().keySet()) {
                    if (this.getChildren().containsKey(child)) {
                        this.getChildren().get(child).merge(toMerge.getChildren().get(child));
                        continue;
                    }
                    this.getChildren().put(child, toMerge.getChildren().get(child));
                }
            }
        }

        public void extractURIInfo(List<URIInfo> uris, String uri) {
            if (this.endpointType != null) {
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(this.endpointType);
                uris.add(info);
            }
            if (this.getChildren() != null) {
                for (String child : this.getChildren().keySet()) {
                    URIPart part = this.getChildren().get(child);
                    part.extractURIInfo(uris, uri + "/" + child);
                }
            }
        }

        public String getEndpointType() {
            return this.endpointType;
        }

        public void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }
    }
}

