/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import io.swagger.annotations.ApiModel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.services.BaseCriteria;

@ApiModel(parent=BaseCriteria.class)
public class CompletionTimeCriteria
extends BaseCriteria {
    private final Logger log = Logger.getLogger(CompletionTimeCriteria.class.getName());
    private long upperBound;
    private long lowerBound;
    private Set<FaultCriteria> faults = new HashSet<FaultCriteria>();

    public long getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(long upperBound) {
        this.upperBound = upperBound;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(long lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Set<FaultCriteria> getFaults() {
        return this.faults;
    }

    public CompletionTimeCriteria setFaults(Set<FaultCriteria> faults) {
        this.faults = faults;
        return this;
    }

    @Override
    public Map<String, String> parameters() {
        Map<String, String> ret = super.parameters();
        if (!this.getFaults().isEmpty()) {
            boolean first = true;
            StringBuilder buf = new StringBuilder();
            for (FaultCriteria pc : this.getFaults()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(pc.encoded());
            }
            ret.put("faults", buf.toString());
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("CompletionTimeCriteria parameters [" + ret + "]");
        }
        return ret;
    }

    @Override
    public String toString() {
        return "CompletionTimeCriteria [upperBound=" + this.upperBound + ", lowerBound=" + this.lowerBound + ", faults=" + this.faults + ", toString()=" + super.toString() + "]";
    }

    public static class FaultCriteria {
        private String value;
        private boolean excluded = false;

        public FaultCriteria() {
        }

        public FaultCriteria(String value, boolean excluded) {
            this.value = value;
            this.excluded = excluded;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        public String encoded() {
            StringBuilder buf = new StringBuilder();
            if (this.isExcluded()) {
                buf.append('-');
            }
            buf.append(this.getValue());
            return buf.toString();
        }
    }
}

