/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionHandler;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.ProcessorIssue;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.Expression;
import org.hawkular.btm.api.model.config.btxn.LiteralExpression;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;

public class LiteralExpressionHandler
extends ExpressionHandler {
    private boolean predicateResult = false;

    public LiteralExpressionHandler(Expression expression) {
        super(expression);
    }

    @Override
    public void init(Processor processor, ProcessorAction action, boolean predicate) {
        LiteralExpression expr = (LiteralExpression)this.getExpression();
        if (predicate) {
            if (!expr.getValue().equalsIgnoreCase("true") && !expr.getValue().equalsIgnoreCase("false")) {
                ProcessorIssue pi = new ProcessorIssue();
                pi.setProcessor(processor.getDescription());
                pi.setAction(action.getDescription());
                pi.setSeverity(Severity.Error);
                pi.setDescription("Literal expression must have a boolean (true/false) value when used as a predicate");
                if (this.getIssues() == null) {
                    this.setIssues(new ArrayList<Issue>());
                }
                this.getIssues().add(pi);
            } else {
                this.predicateResult = new Boolean(((LiteralExpression)this.getExpression()).getValue());
            }
        }
    }

    @Override
    public boolean test(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        return this.predicateResult;
    }

    @Override
    public String evaluate(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        return ((LiteralExpression)this.getExpression()).getValue();
    }
}

