/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionHandler;
import org.hawkular.btm.api.internal.actions.ExpressionHandlerFactory;
import org.hawkular.btm.api.internal.actions.ProcessorActionHandler;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.ProcessorIssue;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.ExpressionBasedAction;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;

public abstract class ExpressionBasedActionHandler
extends ProcessorActionHandler {
    public static final String EXPRESSION_HAS_NOT_BEEN_DEFINED = "Expression has not been defined";
    private static final Logger log = Logger.getLogger(ExpressionBasedActionHandler.class.getName());
    private ExpressionHandler expression = null;

    public ExpressionBasedActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        if (((ExpressionBasedAction)this.getAction()).getExpression() != null) {
            try {
                this.expression = ExpressionHandlerFactory.getHandler(((ExpressionBasedAction)this.getAction()).getExpression());
                this.expression.init(processor, this.getAction(), false);
                if (!this.isUsesHeaders()) {
                    this.setUsesHeaders(this.expression.isUsesHeaders());
                }
                if (!this.isUsesContent()) {
                    this.setUsesContent(this.expression.isUsesContent());
                }
            }
            catch (Throwable t) {
                if (log.isLoggable(Logger.Level.FINE)) {
                    log.log(Logger.Level.FINE, "Failed to compile expression for action '" + this.getAction() + "'", t);
                }
                ProcessorIssue pi = new ProcessorIssue();
                pi.setProcessor(processor.getDescription());
                pi.setAction(this.getAction().getDescription());
                pi.setField("expression");
                pi.setSeverity(Severity.Error);
                pi.setDescription(t.getMessage());
                if (this.getIssues() == null) {
                    this.setIssues(new ArrayList<Issue>());
                }
                this.getIssues().add(pi);
            }
        } else {
            if (log.isLoggable(Logger.Level.FINE)) {
                log.fine("No action expression defined for processor action= " + this.getAction());
            }
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("expression");
            pi.setSeverity(Severity.Error);
            pi.setDescription(EXPRESSION_HAS_NOT_BEEN_DEFINED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(pi);
        }
    }

    protected String getValue(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.expression != null) {
            return this.expression.evaluate(btxn, node, direction, headers, values);
        }
        return null;
    }
}

