/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.btm.api.internal.actions.ExpressionHandler;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.Severity;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Issue;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.ProcessorIssue;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.Expression;
import org.hawkular.btm.api.model.config.btxn.FreeFormExpression;
import org.hawkular.btm.api.model.config.btxn.Processor;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class FreeFormExpressionHandler
extends ExpressionHandler {
    private static final Logger log = Logger.getLogger(FreeFormExpressionHandler.class.getName());
    private Object compiledExpression;

    public FreeFormExpressionHandler(Expression expression) {
        super(expression);
    }

    @Override
    public void init(Processor processor, ProcessorAction action, boolean predicate) {
        try {
            ParserContext ctx = new ParserContext();
            ctx.addPackageImport("org.hawkular.btm.api.internal.actions.helpers");
            String text = ((FreeFormExpression)this.getExpression()).getValue();
            this.compiledExpression = MVEL.compileExpression((String)text, (ParserContext)ctx);
            if (this.compiledExpression == null) {
                log.severe("Failed to compile compiledExpression '" + text + "'");
            } else if (log.isLoggable(Logger.Level.FINE)) {
                log.fine("Initialised free form expression '" + text + "' = " + this.compiledExpression);
            }
        }
        catch (Throwable t) {
            if (log.isLoggable(Logger.Level.FINE)) {
                log.log(Logger.Level.FINE, "Failed to initialise expression", t);
            }
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(action.getDescription());
            pi.setSeverity(Severity.Error);
            pi.setDescription(t.getMessage());
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(pi);
        }
    }

    @Override
    public boolean test(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.compiledExpression != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("btxn", btxn);
            vars.put("node", node);
            vars.put("headers", headers);
            vars.put("values", values);
            Object result = MVEL.executeExpression((Object)this.compiledExpression, vars);
            if (result == null) {
                log.warning("Result for expression '" + this.getExpression() + "' was null");
            } else {
                boolean value = false;
                if (result.getClass() == Boolean.class) {
                    value = (Boolean)result;
                } else if (result.getClass() == String.class) {
                    value = new Boolean((String)result);
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Expression '" + this.getExpression() + "' returned non-boolean type: " + result.getClass());
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Free form expression value=" + value);
                }
                return value;
            }
        }
        return false;
    }

    @Override
    public String evaluate(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.compiledExpression != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("btxn", btxn);
            vars.put("node", node);
            vars.put("headers", headers);
            vars.put("values", values);
            Object result = MVEL.executeExpression((Object)this.compiledExpression, vars);
            if (result == null) {
                log.warning("Result for expression '" + this.getExpression() + "' was null");
            } else {
                String value = null;
                if (result.getClass() != String.class) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Converting result for expression '" + this.getExpression() + "' to a String, was: " + result.getClass());
                    }
                    value = result.toString();
                } else {
                    value = (String)result;
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Free form expression value=" + value);
                }
                return value;
            }
        }
        return null;
    }
}

