/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.btxn.builder;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.trace.BusinessTransactionTrace;
import org.hawkular.btm.api.processors.BusinessTransactionFragmentHandler;
import org.hawkular.btm.api.processors.BusinessTransactionTraceHandler;
import org.hawkular.btm.processor.btxn.builder.BTxnTraceProcessor;
import org.jboss.logging.Logger;

public class BusinessTransactionBuilder
implements BusinessTransactionFragmentHandler {
    private static final Logger log = Logger.getLogger(BusinessTransactionBuilder.class);
    @Inject
    private BTxnTraceProcessor traceProcessor;
    @Inject
    private List<BusinessTransactionTraceHandler> traceHandlers = new ArrayList<BusinessTransactionTraceHandler>();
    private BusinessTransactionFragmentHandler retryHandler;

    public List<BusinessTransactionTraceHandler> getTraceHandlers() {
        return this.traceHandlers;
    }

    public void setTraceHandlers(List<BusinessTransactionTraceHandler> traceHandlers) {
        this.traceHandlers = traceHandlers;
    }

    public BusinessTransactionFragmentHandler getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(BusinessTransactionFragmentHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    public BTxnTraceProcessor getTraceProcessor() {
        return this.traceProcessor;
    }

    public void setTraceProcessor(BTxnTraceProcessor traceProcessor) {
        this.traceProcessor = traceProcessor;
    }

    public void handle(String tenantId, List<BusinessTransaction> btxns) {
        int i;
        log.tracef("Business Transaction Builder called with: %s", btxns);
        ArrayList<BusinessTransaction> retry = null;
        ArrayList<BusinessTransactionTrace> traces = null;
        for (i = 0; i < btxns.size(); ++i) {
            try {
                BusinessTransactionTrace trace = this.traceProcessor.init(btxns.get(i));
                if (trace == null) continue;
                if (traces == null) {
                    traces = new ArrayList<BusinessTransactionTrace>();
                }
                traces.add(trace);
                continue;
            }
            catch (Exception e) {
                log.debug((Object)"Failed to process trace", (Throwable)e);
                if (retry == null) {
                    retry = new ArrayList<BusinessTransaction>();
                }
                retry.add(btxns.get(i));
            }
        }
        if (retry != null && this.getRetryHandler() != null) {
            log.tracef("Retrying %d traces", (Object)retry.size());
            this.getRetryHandler().handle(tenantId, retry);
        }
        if (traces != null && this.getTraceHandlers() != null) {
            for (i = 0; i < this.getTraceHandlers().size(); ++i) {
                this.getTraceHandlers().get(i).handle(tenantId, traces);
            }
        }
    }
}

