/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.btxn.builder;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.hawkular.btm.api.model.trace.BusinessTransactionTrace;
import org.hawkular.btm.processor.btxn.builder.BTxnTraceProcessor;
import org.hawkular.btm.processor.btxn.builder.BTxnTraceScheduler;
import org.hawkular.btm.server.api.processors.BusinessTransactionTraceHandler;
import org.jboss.logging.Logger;

public class BTxnTraceResolver
implements BusinessTransactionTraceHandler {
    private static final Logger log = Logger.getLogger(BTxnTraceResolver.class);
    private BTxnTraceProcessor traceProcessor = new BTxnTraceProcessor();
    @Inject
    private BTxnTraceScheduler scheduler;
    private BusinessTransactionTraceHandler retryHandler;

    public BusinessTransactionTraceHandler getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(BusinessTransactionTraceHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    public BTxnTraceScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(BTxnTraceScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public BTxnTraceProcessor getTraceProcessor() {
        return this.traceProcessor;
    }

    public void setTraceProcessor(BTxnTraceProcessor traceProcessor) {
        this.traceProcessor = traceProcessor;
    }

    public void handle(String tenantId, List<BusinessTransactionTrace> traces) {
        log.tracef("Trace Resolver called with: %s", traces);
        ArrayList<BusinessTransactionTrace> retry = null;
        ArrayList<BusinessTransactionTrace> resolveTraces = null;
        for (int i = 0; i < traces.size(); ++i) {
            if (traces.get(i).isComplete()) continue;
            try {
                BusinessTransactionTrace trace = this.traceProcessor.process(traces.get(i));
                if (trace == null) continue;
                if (resolveTraces == null) {
                    resolveTraces = new ArrayList<BusinessTransactionTrace>();
                }
                resolveTraces.add(trace);
                continue;
            }
            catch (Exception e) {
                log.debug((Object)"Failed to process trace", (Throwable)e);
                if (retry == null) {
                    retry = new ArrayList<BusinessTransactionTrace>();
                }
                retry.add(traces.get(i));
            }
        }
        if (retry != null && this.getRetryHandler() != null) {
            log.tracef("Calling retry handler with: %d traces", retry.size());
            this.getRetryHandler().handle(tenantId, (List)retry);
        }
        if (resolveTraces != null && !resolveTraces.isEmpty() && this.getScheduler() != null) {
            long interval = this.traceProcessor.getScheduleInterval((BusinessTransactionTrace)resolveTraces.get(0));
            this.getScheduler().schedule(tenantId, resolveTraces, interval);
        }
    }
}

