/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.btxn.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Provider;
import org.hawkular.btm.api.model.trace.BusinessTransactionTrace;
import org.hawkular.btm.processor.btxn.builder.BTxnTraceScheduler;
import org.hawkular.btm.server.api.processors.BusinessTransactionTraceHandler;
import org.jboss.logging.Logger;

public class InMemoryBTxnTraceScheduler
implements BTxnTraceScheduler {
    private final Logger log = Logger.getLogger(InMemoryBTxnTraceScheduler.class);
    private List<BusinessTransactionTraceHandler> traceHandlers = new ArrayList<BusinessTransactionTraceHandler>();
    @Inject
    private Provider<List<BusinessTransactionTraceHandler>> handlers;
    @Resource
    private ManagedExecutorService executorService;
    @Resource
    private ManagedScheduledExecutorService scheduledExecutorService;
    private boolean initialised = false;

    protected void init() {
        this.traceHandlers = (List)this.handlers.get();
        this.log.debugf("Setup the trace handlers", new Object[0]);
        this.initialised = true;
    }

    public List<BusinessTransactionTraceHandler> getTraceHandlers() {
        return this.traceHandlers;
    }

    public void setTraceHandlers(List<BusinessTransactionTraceHandler> traceHandlers) {
        this.traceHandlers = traceHandlers;
    }

    @Override
    public void schedule(String tenantId, List<BusinessTransactionTrace> traces, long timeValue) {
        if (!this.initialised) {
            this.init();
        }
        this.scheduledExecutorService.schedule((Runnable)new BTxnTraceSchedulerTask(tenantId, traces), timeValue, TimeUnit.MILLISECONDS);
    }

    private static class BTxnTraceHandlerTask
    implements Runnable {
        private String tenantId;
        private BusinessTransactionTraceHandler handler;
        private List<BusinessTransactionTrace> traces;

        public BTxnTraceHandlerTask(String tenantId, BusinessTransactionTraceHandler handler, List<BusinessTransactionTrace> traces) {
            this.tenantId = tenantId;
            this.handler = handler;
            this.traces = traces;
        }

        @Override
        public void run() {
            this.handler.handle(this.tenantId, this.traces);
        }
    }

    private class BTxnTraceSchedulerTask
    implements Runnable {
        private String tenantId;
        private List<BusinessTransactionTrace> traces;

        public BTxnTraceSchedulerTask(String tenantId, List<BusinessTransactionTrace> traces) {
            this.tenantId = tenantId;
            this.traces = traces;
        }

        @Override
        public void run() {
            for (int i = 0; i < InMemoryBTxnTraceScheduler.this.traceHandlers.size(); ++i) {
                InMemoryBTxnTraceScheduler.this.executorService.execute((Runnable)new BTxnTraceHandlerTask(this.tenantId, (BusinessTransactionTraceHandler)InMemoryBTxnTraceScheduler.this.traceHandlers.get(i), this.traces));
            }
        }
    }
}

