/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.btxn.service.bus;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.MessageListener;
import org.hawkular.btm.api.log.MsgLogger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.bus.common.SimpleBasicMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularBTM.BTxnFragments")})
public class BusinessTransactionsFragmentsListener
extends BasicMessageListener<SimpleBasicMessage> {
    private final Logger log = Logger.getLogger(BusinessTransactionsFragmentsListener.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    @Inject
    private BusinessTransactionService businessTransactionService;

    protected void onBasicMessage(SimpleBasicMessage msg) {
        this.log.tracef("Business Transaction Service STORE request: %s", (Object)msg.getMessage());
        List btxns = null;
        try {
            btxns = (List)this.mapper.readValue(msg.getMessage(), BUSINESS_TXN_LIST);
        }
        catch (Exception e) {
            this.msgLog.errorFailedToDeserializeJson(msg.getMessage(), (Throwable)e);
        }
        if (btxns != null) {
            try {
                this.businessTransactionService.store(btxns);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

