/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.btxn.service.bus;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import org.hawkular.btm.api.log.MsgLogger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.bus.common.SimpleBasicMessage;
import org.hawkular.bus.mdb.RPCBasicMessageDrivenBean;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularBTM.BTxnService.Get")})
public class BusinessTransactionsGetListener
extends RPCBasicMessageDrivenBean<SimpleBasicMessage, SimpleBasicMessage> {
    private final Logger log = Logger.getLogger(BusinessTransactionsGetListener.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private ObjectMapper mapper = new ObjectMapper();
    @Inject
    private BusinessTransactionService businessTransactionService;
    @Resource(mappedName="java:/HawkularBusConnectionFactory")
    private ConnectionFactory connectionFactory;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected SimpleBasicMessage onBasicMessage(SimpleBasicMessage msg) {
        this.log.tracef("Business Transaction Service GET request: id[%s]", (Object)msg.getMessage());
        BusinessTransaction btxn = this.businessTransactionService.get(msg.getMessage());
        String resp = null;
        try {
            resp = this.mapper.writeValueAsString((Object)btxn);
        }
        catch (JsonProcessingException e) {
            this.msgLog.errorFailedToSerializeToJson((Throwable)e);
        }
        this.log.tracef("Business Transaction Service GET request: id[%s] btxn=%s", (Object)msg.getMessage(), (Object)btxn);
        return new SimpleBasicMessage(resp);
    }
}

