/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.btxn.service.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionPublisher;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.api.services.Criteria;
import org.hawkular.btm.btxn.publisher.rest.client.BusinessTransactionPublisherRESTClient;

public class BusinessTransactionServiceRESTClient
extends BusinessTransactionPublisherRESTClient
implements BusinessTransactionService,
BusinessTransactionPublisher {
    private static final Logger log = Logger.getLogger((String)BusinessTransactionServiceRESTClient.class.getName());
    private static final TypeReference<List<BusinessTransaction>> BUSINESS_TXN_LIST = new TypeReference<List<BusinessTransaction>>(){};
    private static final ObjectMapper mapper = new ObjectMapper();

    public BusinessTransaction get(String tenantId, String id) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction: tenantId=[" + tenantId + "] id=[" + id + "]");
        }
        try {
            URL url = new URL(this.getBaseUrl() + "fragments/" + id);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            byte[] b = new byte[is.available()];
            is.read(b);
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + new String(b) + "]");
                }
                try {
                    return (BusinessTransaction)mapper.readValue(b, BusinessTransaction.class);
                }
                catch (Throwable t) {
                    log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to get business transaction: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'get' business transaction request", (Throwable)e);
        }
        return null;
    }

    public List<BusinessTransaction> query(String tenantId, Criteria criteria) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction fragments: tenantId=[" + tenantId + "] query=[" + criteria + "]");
        }
        try {
            URL url = new URL(this.getQueryURL(criteria));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            InputStream is = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            String str = null;
            while ((str = reader.readLine()) != null) {
                builder.append(str);
            }
            is.close();
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Returned json=[" + builder.toString() + "]");
                }
                try {
                    return (List)mapper.readValue(builder.toString(), BUSINESS_TXN_LIST);
                }
                catch (Throwable t) {
                    log.log(Logger.Level.SEVERE, "Failed to deserialize", t);
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to query business transaction fragment: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'query' business transaction request", (Throwable)e);
        }
        return null;
    }

    protected String getQueryURL(Criteria criteria) {
        Map queryParams = criteria.parameters();
        StringBuilder builder = new StringBuilder().append(this.getBaseUrl()).append("fragments");
        if (!queryParams.isEmpty()) {
            builder.append('?');
            boolean first = true;
            for (String key : queryParams.keySet()) {
                if (!first) {
                    builder.append('&');
                }
                String value = (String)queryParams.get(key);
                builder.append(key);
                builder.append('=');
                builder.append(value);
                first = false;
            }
        }
        return builder.toString();
    }

    public void storeBusinessTransactions(String tenantId, List<BusinessTransaction> businessTransactions) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void clear(String tenantId) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Clear business transaction fragments: tenantId=[" + tenantId + "]");
        }
        try {
            URL url = new URL(this.getBaseUrl() + "fragments");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Type", "application/json");
            this.addHeaders(connection, tenantId);
            if (connection.getResponseCode() == 200) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Business transaction fragments cleared");
                }
            } else if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Failed to clear business transaction fragments: status=[" + connection.getResponseCode() + "]:" + connection.getResponseMessage());
            }
        }
        catch (Exception e) {
            log.log(Logger.Level.SEVERE, "Failed to send 'query' business transaction request", (Throwable)e);
        }
    }
}

