/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.services.ServiceResolver;
import org.hawkular.btm.client.api.BusinessTransactionCollector;
import org.hawkular.btm.client.api.HeadersAccessor;
import org.hawkular.btm.client.manager.ArrayBuilder;
import org.hawkular.btm.client.manager.ClientManager;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

public class RuleHelper
extends Helper {
    private static final Logger log = Logger.getLogger((String)RuleHelper.class.getName());
    private static Map<String, HeadersAccessor> headersAccessors = new HashMap<String, HeadersAccessor>();

    protected RuleHelper(Rule rule) {
        super(rule);
    }

    public BusinessTransactionCollector collector() {
        return ClientManager.collector();
    }

    public String createUUID() {
        return UUID.randomUUID().toString();
    }

    public String getID(String type, Object obj) {
        return type + obj.hashCode();
    }

    public boolean isInstanceOf(Object obj, Class<?> clz) {
        if (obj == null || clz == null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("isInstanceOf error: obj=" + obj + " clz=" + clz);
            }
            return false;
        }
        return clz.isAssignableFrom(obj.getClass());
    }

    public String simpleClassName(Object obj) {
        return obj.getClass().getSimpleName();
    }

    public String removeSuffix(String original, String suffix) {
        if (original.endsWith(suffix)) {
            return original.substring(0, original.length() - suffix.length());
        }
        return original;
    }

    public ArrayBuilder createArrayBuilder() {
        return new ArrayBuilder();
    }

    public Map<String, String> getHeaders(String type, Object target) {
        HeadersAccessor accessor = this.getHeadersAccessor(type);
        if (accessor != null) {
            Map ret = accessor.getHeaders(target);
            return ret;
        }
        return null;
    }

    protected HeadersAccessor getHeadersAccessor(String type) {
        return headersAccessors.get(type);
    }

    static {
        List accessors = ServiceResolver.getServices(HeadersAccessor.class);
        for (HeadersAccessor accessor : accessors) {
            headersAccessors.put(accessor.getTargetType(), accessor);
        }
    }
}

