/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import org.jboss.byteman.agent.LocationType;
import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.EntryCheckAdapter;
import org.jboss.byteman.agent.adapter.EntryTriggerAdapter;
import org.jboss.byteman.agent.adapter.ExitCheckAdapter;
import org.jboss.byteman.agent.adapter.ExitTriggerAdapter;
import org.jboss.byteman.agent.adapter.FieldAccessCheckAdapter;
import org.jboss.byteman.agent.adapter.FieldAccessTriggerAdapter;
import org.jboss.byteman.agent.adapter.IndexParamAccessCheckAdapter;
import org.jboss.byteman.agent.adapter.IndexParamAccessTriggerAdapter;
import org.jboss.byteman.agent.adapter.InvokeCheckAdapter;
import org.jboss.byteman.agent.adapter.InvokeTriggerAdapter;
import org.jboss.byteman.agent.adapter.LineCheckAdapter;
import org.jboss.byteman.agent.adapter.LineTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleCheckAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.SynchronizeCheckAdapter;
import org.jboss.byteman.agent.adapter.SynchronizeTriggerAdapter;
import org.jboss.byteman.agent.adapter.ThrowCheckAdapter;
import org.jboss.byteman.agent.adapter.ThrowTriggerAdapter;
import org.jboss.byteman.agent.adapter.VariableAccessCheckAdapter;
import org.jboss.byteman.agent.adapter.VariableAccessTriggerAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.rule.type.TypeHelper;

public abstract class Location {
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;

    public static Location create(LocationType type, String parameters) {
        switch (type) {
            case ENTRY: {
                return EntryLocation.create(parameters);
            }
            case LINE: {
                return LineLocation.create(parameters);
            }
            case READ: {
                return AccessLocation.create(parameters, 1, false);
            }
            case READ_COMPLETED: {
                return AccessLocation.create(parameters, 1, true);
            }
            case WRITE: {
                return AccessLocation.create(parameters, 2, false);
            }
            case WRITE_COMPLETED: {
                return AccessLocation.create(parameters, 2, true);
            }
            case INVOKE: {
                return InvokeLocation.create(parameters, false);
            }
            case INVOKE_COMPLETED: {
                return InvokeLocation.create(parameters, true);
            }
            case SYNCHRONIZE: {
                return SynchronizeLocation.create(parameters, false);
            }
            case SYNCHRONIZE_COMPLETED: {
                return SynchronizeLocation.create(parameters, true);
            }
            case THROW: {
                return ThrowLocation.create(parameters);
            }
            case EXIT: {
                return ExitLocation.create(parameters);
            }
        }
        return null;
    }

    public abstract RuleCheckAdapter getRuleCheckAdapter(ClassVisitor var1, TransformContext var2);

    public abstract RuleTriggerAdapter getRuleAdapter(ClassVisitor var1, TransformContext var2);

    public abstract LocationType getLocationType();

    private static class ExitLocation
    extends Location {
        private ExitLocation() {
        }

        protected static Location create(String parameters) {
            if (!parameters.trim().equals("")) {
                return null;
            }
            return new ExitLocation();
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new ExitCheckAdapter(cv, transformContext);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new ExitTriggerAdapter(cv, transformContext);
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.EXIT;
        }

        public String toString() {
            return "AT EXIT";
        }
    }

    private static class ThrowLocation
    extends Location {
        private int count;
        private String typeName;

        private ThrowLocation(int count, String typeName) {
            this.count = count;
            this.typeName = typeName;
        }

        protected static Location create(String parameters) {
            int count;
            String text = parameters.trim();
            String typeName = "";
            if (text.equals("")) {
                count = 1;
            } else if (text.equals("ALL")) {
                count = 0;
            } else {
                try {
                    count = Integer.valueOf(text);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            return new ThrowLocation(count, typeName);
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new ThrowCheckAdapter(cv, transformContext, this.typeName, this.count);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new ThrowTriggerAdapter(cv, transformContext, this.typeName, this.count);
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.THROW;
        }

        public String toString() {
            String text = "AT THROW";
            if (this.count != 1) {
                text = this.count == 0 ? text + " ALL" : text + " " + this.count;
            }
            return text;
        }
    }

    private static class SynchronizeLocation
    extends Location {
        private int count;
        private boolean whenComplete;

        private SynchronizeLocation(int count, boolean whenComplete) {
            this.count = count;
            this.whenComplete = whenComplete;
        }

        protected static Location create(String parameters, boolean whenComplete) {
            int count;
            String text = parameters.trim();
            if (text.length() != 0) {
                if (text.equals("ALL")) {
                    count = 0;
                } else {
                    try {
                        count = Integer.valueOf(text);
                    }
                    catch (NumberFormatException nfe) {
                        return null;
                    }
                }
            } else {
                count = 1;
            }
            return new SynchronizeLocation(count, whenComplete);
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new SynchronizeCheckAdapter(cv, transformContext, this.count);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new SynchronizeTriggerAdapter(cv, transformContext, this.count, this.whenComplete);
        }

        @Override
        public LocationType getLocationType() {
            if (this.whenComplete) {
                return LocationType.SYNCHRONIZE_COMPLETED;
            }
            return LocationType.SYNCHRONIZE;
        }

        public String toString() {
            String text = this.whenComplete ? "AFTER SYNCHRONIZE" : "AT SYNCHRONIZE";
            if (this.count != 1) {
                text = this.count == 0 ? text + " ALL" : text + " " + this.count;
            }
            return text;
        }
    }

    private static class InvokeLocation
    extends Location {
        private String methodName;
        private String typeName;
        private String signature;
        private int count;
        private boolean whenComplete;

        private InvokeLocation(String typeName, String methodName, String signature, int count, boolean whenComplete) {
            this.typeName = typeName;
            this.methodName = methodName;
            this.signature = signature;
            this.count = count;
            this.whenComplete = whenComplete;
        }

        protected static Location create(String parameters, boolean whenComplete) {
            String fieldName;
            String typeName;
            String signature;
            int count;
            int tailIdx;
            String text = parameters.trim();
            if (text.contains(")")) {
                tailIdx = text.lastIndexOf(")");
                String countText = text.substring(tailIdx + 1).trim();
                if (!countText.equals("")) {
                    if (countText.equals("ALL")) {
                        count = 0;
                    } else {
                        try {
                            count = Integer.valueOf(countText);
                        }
                        catch (NumberFormatException nfe) {
                            return null;
                        }
                    }
                } else {
                    count = 1;
                }
                text = text.substring(0, tailIdx + 1).trim();
            } else if (text.contains(" ")) {
                tailIdx = text.lastIndexOf(" ");
                String countText = text.substring(tailIdx + 1).trim();
                if (!countText.equals("")) {
                    if (countText.equals("ALL")) {
                        count = 0;
                    } else {
                        try {
                            count = Integer.valueOf(countText);
                        }
                        catch (NumberFormatException nfe) {
                            return null;
                        }
                    }
                } else {
                    count = 1;
                }
                text = text.substring(0, tailIdx).trim();
            } else {
                count = 1;
            }
            if (text.contains("(")) {
                signature = TypeHelper.parseMethodDescriptor(text);
                text = TypeHelper.parseMethodName(text);
            } else {
                signature = "";
            }
            if (text.contains(".")) {
                int dotIdx = text.lastIndexOf(".");
                typeName = text.substring(0, dotIdx).trim();
                fieldName = text.substring(dotIdx + 1).trim();
            } else {
                typeName = null;
                fieldName = text;
            }
            return new InvokeLocation(typeName, fieldName, signature, count, whenComplete);
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new InvokeCheckAdapter(cv, transformContext, this.typeName, this.methodName, this.signature, this.count);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new InvokeTriggerAdapter(cv, transformContext, this.typeName, this.methodName, this.signature, this.count, this.whenComplete);
        }

        @Override
        public LocationType getLocationType() {
            if (this.whenComplete) {
                return LocationType.INVOKE_COMPLETED;
            }
            return LocationType.INVOKE;
        }

        public String toString() {
            String text = this.whenComplete ? "AFTER INVOKE " : "AT INVOKE ";
            if (this.typeName != null) {
                text = text + this.typeName + ".";
            }
            text = text + this.methodName;
            if (this.signature.length() > 0) {
                text = text + TypeHelper.internalizeDescriptor(this.signature);
            }
            if (this.count != 1) {
                text = this.count == 0 ? text + " ALL" : text + " " + this.count;
            }
            return text;
        }
    }

    private static class VariableAccessLocation
    extends AccessLocation {
        private String variableName;
        private boolean isIndex;

        protected VariableAccessLocation(String variablename, int count, int flags, boolean whenComplete) {
            super(count, flags, whenComplete);
            this.variableName = variablename;
            this.isIndex = variablename.matches("[0-9]+");
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            if (this.isIndex) {
                int paramIdx = Integer.valueOf(this.variableName);
                return new IndexParamAccessCheckAdapter(cv, transformContext, paramIdx, this.flags, this.count);
            }
            return new VariableAccessCheckAdapter(cv, transformContext, this.variableName, this.flags, this.count);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            if (this.isIndex) {
                int paramIdx = Integer.valueOf(this.variableName);
                return new IndexParamAccessTriggerAdapter(cv, transformContext, paramIdx, this.flags, this.count, this.whenComplete);
            }
            return new VariableAccessTriggerAdapter(cv, transformContext, this.variableName, this.flags, this.count, this.whenComplete);
        }

        @Override
        public LocationType getLocationType() {
            if ((this.flags & 2) != 0) {
                if (this.whenComplete) {
                    return LocationType.WRITE_COMPLETED;
                }
                return LocationType.WRITE;
            }
            if (this.whenComplete) {
                return LocationType.READ_COMPLETED;
            }
            return LocationType.READ;
        }

        public String toString() {
            String text = this.whenComplete ? "AFTER " : "AT ";
            text = this.flags == 1 ? text + "READ " : (this.flags == 2 ? text + "WRITE " : text + "ACCESS ");
            text = text + "$";
            text = text + this.variableName;
            if (this.count != 1) {
                text = this.count == 0 ? text + " ALL" : text + " " + this.count;
            }
            return text;
        }
    }

    private static class FieldAccessLocation
    extends AccessLocation {
        private String fieldName;
        private String typeName;

        private FieldAccessLocation(String typeName, String fieldName, int count, int flags, boolean whenComplete) {
            super(count, flags, whenComplete);
            this.typeName = typeName;
            this.fieldName = fieldName;
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new FieldAccessCheckAdapter(cv, transformContext, this.typeName, this.fieldName, this.flags, this.count);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new FieldAccessTriggerAdapter(cv, transformContext, this.typeName, this.fieldName, this.flags, this.count, this.whenComplete);
        }

        public String toString() {
            String text = this.whenComplete ? "AFTER " : "AT ";
            text = this.flags == 1 ? text + "READ " : (this.flags == 2 ? text + "WRITE " : text + "ACCESS ");
            if (this.typeName != null) {
                text = text + this.typeName + ".";
            }
            text = text + this.fieldName;
            if (this.count != 1) {
                text = this.count == 0 ? text + " ALL" : text + " " + this.count;
            }
            return text;
        }
    }

    private static abstract class AccessLocation
    extends Location {
        protected int count;
        protected int flags;
        protected boolean whenComplete;

        protected AccessLocation(int count, int flags, boolean whenComplete) {
            this.count = count;
            this.flags = flags;
            this.whenComplete = whenComplete;
        }

        protected static Location create(String parameters, int flags, boolean whenComplete) {
            String fieldName;
            String typeName;
            int count;
            String text = parameters.trim();
            if (text.contains(" ")) {
                int spaceIdx = text.lastIndexOf(" ");
                String countText = text.substring(spaceIdx).trim();
                if (countText.equals("ALL")) {
                    count = 0;
                } else {
                    try {
                        count = Integer.valueOf(countText);
                    }
                    catch (NumberFormatException nfe) {
                        return null;
                    }
                }
                text = text.substring(0, spaceIdx).trim();
            } else {
                count = 1;
            }
            if (text.equals("")) {
                return null;
            }
            if (text.startsWith("$")) {
                String varname = text.substring(1).trim();
                return new VariableAccessLocation(varname, count, flags, whenComplete);
            }
            if (text.contains(".")) {
                int dotIdx = text.lastIndexOf(".");
                typeName = text.substring(0, dotIdx).trim();
                fieldName = text.substring(dotIdx + 1).trim();
            } else {
                typeName = null;
                fieldName = text;
            }
            return new FieldAccessLocation(typeName, fieldName, count, flags, whenComplete);
        }

        @Override
        public LocationType getLocationType() {
            if ((this.flags & 2) != 0) {
                if (this.whenComplete) {
                    return LocationType.WRITE_COMPLETED;
                }
                return LocationType.WRITE;
            }
            if (this.whenComplete) {
                return LocationType.READ_COMPLETED;
            }
            return LocationType.READ;
        }
    }

    private static class LineLocation
    extends Location {
        private int targetLine;

        private LineLocation(int targetLine) {
            this.targetLine = targetLine;
        }

        protected static Location create(String parameters) {
            try {
                int targetLine = Integer.decode(parameters.trim());
                return new LineLocation(targetLine);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new LineCheckAdapter(cv, transformContext, this.targetLine);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new LineTriggerAdapter(cv, transformContext, this.targetLine);
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.LINE;
        }

        public String toString() {
            return "AT LINE " + this.targetLine;
        }
    }

    private static class EntryLocation
    extends Location {
        private EntryLocation() {
        }

        protected static Location create(String parameters) {
            if (!parameters.trim().equals("")) {
                return null;
            }
            return new EntryLocation();
        }

        @Override
        public RuleCheckAdapter getRuleCheckAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new EntryCheckAdapter(cv, transformContext);
        }

        @Override
        public RuleTriggerAdapter getRuleAdapter(ClassVisitor cv, TransformContext transformContext) {
            return new EntryTriggerAdapter(cv, transformContext);
        }

        @Override
        public LocationType getLocationType() {
            return LocationType.ENTRY;
        }

        public String toString() {
            return "AT ENTRY";
        }
    }
}

