/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter.cfg;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.byteman.agent.adapter.OpcodesHelper;
import org.jboss.byteman.agent.adapter.cfg.CFG;
import org.jboss.byteman.agent.adapter.cfg.CodeLocation;
import org.jboss.byteman.agent.adapter.cfg.FanOut;
import org.jboss.byteman.agent.adapter.cfg.InstructionSequence;
import org.jboss.byteman.agent.adapter.cfg.TriggerDetails;
import org.jboss.byteman.agent.adapter.cfg.TryCatchDetails;
import org.jboss.byteman.objectweb.asm.Label;

public class BBlock {
    private CFG cfg;
    private InstructionSequence instructions;
    private FanOut outGoing;
    private int blockIdx;
    private List<TryCatchDetails> activeTryStarts;
    private List<TryCatchDetails> tryStarts;
    private List<TryCatchDetails> tryEnds;
    private List<TryCatchDetails> handlerStarts;
    private LinkedList<CodeLocation> monitorEnters;
    private LinkedList<CodeLocation> monitorExits;

    public BBlock(CFG cfg, Label start, int blockIdx) {
        this.cfg = cfg;
        this.instructions = new InstructionSequence();
        this.outGoing = new FanOut(start);
        this.blockIdx = blockIdx;
        this.activeTryStarts = null;
        this.tryStarts = new LinkedList<TryCatchDetails>();
        this.tryEnds = new LinkedList<TryCatchDetails>();
        this.handlerStarts = new LinkedList<TryCatchDetails>();
        this.monitorEnters = new LinkedList();
        this.monitorExits = new LinkedList();
    }

    public CFG getCFG() {
        return this.cfg;
    }

    public Label getLabel() {
        return this.outGoing.getFrom();
    }

    public int getBlockIdx() {
        return this.blockIdx;
    }

    public int append(int instruction) {
        int index = this.instructions.add(instruction);
        if (instruction == 194) {
            this.monitorEnters.push(new CodeLocation(this, index));
        } else if (instruction == 195) {
            CodeLocation exit = new CodeLocation(this, index);
            this.monitorExits.add(exit);
            if (!this.monitorEnters.isEmpty()) {
                CodeLocation enter = this.monitorEnters.pop();
                this.cfg.addMonitorPair(enter, exit);
            }
        }
        return index;
    }

    public int append(int instruction, int operand) {
        return this.instructions.add(instruction, operand);
    }

    public int append(int instruction, int operand1, int operand2) {
        return this.instructions.add(instruction, operand1, operand2);
    }

    public int append(int instruction, int operand1, int operand2, int operand3) {
        return this.instructions.add(instruction, operand1, operand2, operand3);
    }

    public int append(int instruction, int operand1, int operand2, int operand3, int operand4) {
        return this.instructions.add(instruction, operand1, operand2, operand3, operand4);
    }

    public int append(int instruction, int[] operands) {
        return this.instructions.add(instruction, operands);
    }

    public void addTryStarts(List<TryCatchDetails> details) {
        this.tryStarts.addAll(details);
    }

    public void addTryEnds(List<TryCatchDetails> details) {
        this.tryEnds.addAll(details);
    }

    public void addHandlerStarts(List<TryCatchDetails> details) {
        this.handlerStarts.addAll(details);
    }

    public void setActiveTryStarts(List<TryCatchDetails> active) {
        this.activeTryStarts = active;
    }

    public Iterator<TryCatchDetails> getTryEnds() {
        return this.tryEnds.iterator();
    }

    public Iterator<TryCatchDetails> getHandlerStarts() {
        return this.handlerStarts.iterator();
    }

    public List<TryCatchDetails> getActiveTryStarts() {
        return this.activeTryStarts;
    }

    public Iterator<CodeLocation> getMonitorEnters() {
        return this.monitorEnters.iterator();
    }

    public Iterator<CodeLocation> getMonitorExits() {
        return this.monitorExits.iterator();
    }

    public int getMonitorEnterCount() {
        return this.monitorEnters.size();
    }

    public int getMonitorExitCount() {
        return this.monitorExits.size();
    }

    public int getInstructionCount() {
        return this.instructions.size();
    }

    public int getInstruction(int index) {
        return this.instructions.get(index);
    }

    public int getInstructionArg(int index, int argIndex) {
        return this.instructions.getArg(index, argIndex);
    }

    public void append(Label label) {
        this.outGoing.append(label);
    }

    public Label next() {
        return this.outGoing.getTo(0);
    }

    public Label firstOut() {
        return this.outGoing.getTo(1);
    }

    public Label secondOut() {
        return this.outGoing.getTo(2);
    }

    public Label nthOut(int n) {
        return this.outGoing.getTo(n);
    }

    public int nOuts() {
        return this.outGoing.getToCount() - 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.printTo(buf);
        return buf.toString();
    }

    void printTo(StringBuffer buf) {
        int containedPosition;
        Label containedLabel;
        Iterator<Label> containsIter;
        int blockIdx = this.getBlockIdx();
        buf.append(this.getLabel().getOffset());
        buf.append(": BB ");
        buf.append(blockIdx);
        buf.append("\n");
        FanOut containsFanOut = this.cfg.getContains(this);
        if (containsFanOut != null) {
            containsIter = containsFanOut.iterator();
            if (containsIter.hasNext()) {
                containedLabel = containsIter.next();
                containedPosition = this.cfg.getBlockInstructionIdx(containedLabel);
            } else {
                containedLabel = null;
                containedPosition = -1;
            }
        } else {
            containsIter = null;
            containedLabel = null;
            containedPosition = -1;
        }
        int instructionCount = this.getInstructionCount();
        block35: for (int i = 0; i < instructionCount; ++i) {
            while (containedPosition == i) {
                int openCount;
                CodeLocation handlerLocation;
                Label handlerLabel;
                TryCatchDetails details;
                int j;
                int detailsCount;
                List<TryCatchDetails> detailsList;
                buf.append(containedLabel.getOffset());
                buf.append(": ");
                buf.append(containedLabel);
                buf.append(" +");
                buf.append(containedPosition);
                if (this.cfg.tryCatchStart(containedLabel)) {
                    detailsList = this.cfg.tryCatchStartDetails(containedLabel);
                    detailsCount = detailsList.size();
                    for (j = 0; j < detailsCount; ++j) {
                        details = detailsList.get(j);
                        handlerLabel = details.getHandler();
                        handlerLocation = this.cfg.getLocation(handlerLabel);
                        buf.append(" try ");
                        buf.append(details.getType());
                        buf.append(" ");
                        if (handlerLocation != null) {
                            buf.append(handlerLabel.getOffset());
                        } else {
                            buf.append("??");
                        }
                        buf.append(" ");
                        buf.append(handlerLabel);
                    }
                }
                if (this.cfg.tryCatchEnd(containedLabel)) {
                    detailsList = this.cfg.tryCatchEndDetails(containedLabel);
                    detailsCount = detailsList.size();
                    for (j = 0; j < detailsCount; ++j) {
                        details = detailsList.get(j);
                        handlerLabel = details.getHandler();
                        handlerLocation = this.cfg.getLocation(handlerLabel);
                        buf.append(" catch ");
                        buf.append(details.getType());
                        buf.append(" ");
                        if (handlerLocation != null) {
                            buf.append(handlerLabel.getOffset());
                        } else {
                            buf.append("??");
                        }
                        buf.append(" ");
                        buf.append(handlerLabel);
                    }
                }
                if (this.cfg.tryCatchHandlerStart(containedLabel)) {
                    detailsList = this.cfg.tryCatchHandlerStartDetails(containedLabel);
                    detailsCount = detailsList.size();
                    for (j = 0; j < detailsCount; ++j) {
                        details = detailsList.get(j);
                        buf.append(" handle ");
                        buf.append(details.getType());
                        buf.append(" ");
                        buf.append(details.getStart().getOffset());
                        buf.append(" ");
                        buf.append(details.getEnd().getOffset());
                    }
                }
                if (this.cfg.triggerStart(containedLabel)) {
                    buf.append(" trigger start");
                    TriggerDetails details2 = this.cfg.triggerStartDetails(containedLabel);
                }
                if (this.cfg.triggerEnd(containedLabel)) {
                    buf.append(" trigger end");
                }
                buf.append("\n");
                List<CodeLocation> openEnters = this.cfg.getOpenMonitorEnters(containedLabel);
                if (openEnters != null && (openCount = openEnters.size()) > 0) {
                    buf.append("open monitors: ");
                    for (j = 0; j < openCount; ++j) {
                        CodeLocation l = openEnters.get(j);
                        buf.append(" BB");
                        buf.append(l.getBlock().getBlockIdx());
                        buf.append(".");
                        buf.append(l.getInstructionIdx());
                    }
                    buf.append('\n');
                }
                containedLabel = containsIter.hasNext() ? containsIter.next() : null;
                containedPosition = containedLabel != null ? this.cfg.getBlockInstructionIdx(containedLabel) : -1;
            }
            buf.append(blockIdx);
            buf.append(".");
            buf.append(i);
            buf.append(": ");
            int opcode = this.getInstruction(i);
            switch (OpcodesHelper.insnType(opcode)) {
                case 0: {
                    buf.append(OpcodesHelper.insnName(opcode));
                    if (opcode == 195) {
                        CodeLocation exit = new CodeLocation(this, i);
                        CodeLocation enter = this.cfg.getPairedEnter(exit);
                        buf.append(" (enter: ");
                        buf.append(enter);
                        buf.append(")");
                    }
                    buf.append("\n");
                    continue block35;
                }
                case 1: {
                    int intValue = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(intValue);
                    buf.append("\n");
                    continue block35;
                }
                case 2: {
                    int nameIdx = this.getInstructionArg(i, 0);
                    String name = this.cfg.getName(nameIdx);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(name);
                    buf.append("\n");
                    continue block35;
                }
                case 3: {
                    int varIdx = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(varIdx);
                    buf.append("\n");
                    continue block35;
                }
                case 4: {
                    int increment = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(increment);
                    buf.append("\n");
                    continue block35;
                }
                case 5: {
                    Label targetLabel = this.firstOut();
                    CodeLocation targetLocation = this.cfg.getLocation(targetLabel);
                    int targetPos = targetLocation != null ? targetLabel.getOffset() : -1;
                    switch (opcode) {
                        case 153: {
                            buf.append("IFEQ ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 154: {
                            buf.append("IFNE ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 155: {
                            buf.append("IFLT ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 156: {
                            buf.append("IFGE ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 157: {
                            buf.append("IFGT ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 158: {
                            buf.append("IFLE ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 159: {
                            buf.append("IF_ICMPEQ ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 160: {
                            buf.append("IF_ICMPNE ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 161: {
                            buf.append("IF_ICMPLT ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 162: {
                            buf.append("IF_ICMPGE ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 163: {
                            buf.append("IF_ICMPGT ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 164: {
                            buf.append("IF_ICMPLE ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 165: {
                            buf.append("IF_ACMPEQ ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 166: {
                            buf.append("IF_ACMPNE ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 167: {
                            buf.append("GOTO ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 168: {
                            buf.append("JSR ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 198: {
                            buf.append("IFNULL ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                            break;
                        }
                        case 199: {
                            buf.append("IFNONNULL ");
                            if (targetPos >= 0) {
                                buf.append(targetPos);
                                buf.append(" BB ");
                                buf.append(targetLocation.getBlock().getBlockIdx());
                                buf.append(" ");
                                buf.append(targetLabel);
                            } else {
                                buf.append("??  ");
                                buf.append(targetLabel);
                            }
                            buf.append("\n");
                        }
                    }
                    continue block35;
                }
                case 6: {
                    int min = this.getInstructionArg(i, 0);
                    int max = this.getInstructionArg(i, 1);
                    int count = max + 1 - min;
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(min);
                    buf.append(" ");
                    buf.append(max);
                    buf.append("\n");
                    for (int j = 1; j <= count; ++j) {
                        Label targetLabel = this.nthOut(j);
                        CodeLocation targetLocation = this.cfg.getLocation(targetLabel);
                        int targetPos = targetLocation != null ? targetLabel.getOffset() : -1;
                        buf.append("    ");
                        buf.append(min + j);
                        buf.append(" : ");
                        if (targetPos >= 0) {
                            buf.append(targetPos);
                            buf.append(" BB ");
                            buf.append(targetLocation.getBlock().getBlockIdx());
                            buf.append(" ");
                            buf.append(targetLabel);
                            continue;
                        }
                        buf.append("??  ");
                        buf.append(targetLabel);
                    }
                    Label targetLabel = this.firstOut();
                    CodeLocation targetLocation = this.cfg.getLocation(targetLabel);
                    int targetPos = targetLocation != null ? targetLabel.getOffset() : -1;
                    buf.append("    dflt : ");
                    if (targetPos >= 0) {
                        buf.append(targetPos);
                        buf.append(" BB ");
                        buf.append(targetLocation.getBlock().getBlockIdx());
                        buf.append(" ");
                        buf.append(targetLabel);
                        continue block35;
                    }
                    buf.append("??  ");
                    buf.append(targetLabel);
                    continue block35;
                }
                case 7: {
                    int count = this.getInstructionArg(i, 0);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append("\n");
                    for (int j = 1; j <= count; ++j) {
                        Label targetLabel = this.nthOut(j);
                        CodeLocation targetLocation = this.cfg.getLocation(targetLabel);
                        int targetPos = targetLocation != null ? targetLabel.getOffset() : -1;
                        buf.append("    ");
                        buf.append(this.getInstructionArg(i, j));
                        buf.append(" : ");
                        if (targetPos >= 0) {
                            buf.append(targetPos);
                            buf.append(" BB ");
                            buf.append(targetLocation.getBlock().getBlockIdx());
                            buf.append(" ");
                            buf.append(targetLabel);
                            continue;
                        }
                        buf.append("??  ");
                        buf.append(targetLabel);
                    }
                    Label targetLabel = this.firstOut();
                    CodeLocation targetLocation = this.cfg.getLocation(targetLabel);
                    int targetPos = targetLocation != null ? targetLabel.getOffset() : -1;
                    buf.append("    dflt : ");
                    if (targetPos >= 0) {
                        buf.append(targetPos);
                        buf.append(" BB ");
                        buf.append(targetLocation.getBlock().getBlockIdx());
                        buf.append(" ");
                        buf.append(targetLabel);
                        continue block35;
                    }
                    buf.append("??  ");
                    buf.append(targetLabel);
                    continue block35;
                }
                case 8: 
                case 9: {
                    int idx1 = this.getInstructionArg(i, 0);
                    int idx2 = this.getInstructionArg(i, 1);
                    int idx3 = this.getInstructionArg(i, 2);
                    String owner = this.cfg.getName(idx1);
                    String name = this.cfg.getName(idx2);
                    String desc = this.cfg.getName(idx3);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(owner);
                    buf.append(" ");
                    buf.append(name);
                    buf.append(" ");
                    buf.append(desc);
                    buf.append("\n");
                    continue block35;
                }
                case 12: {
                    int idx1 = this.getInstructionArg(i, 0);
                    int idx2 = this.getInstructionArg(i, 1);
                    String owner = this.cfg.getName(idx1);
                    String name = this.cfg.getName(idx2);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(owner);
                    buf.append(" ");
                    buf.append(name);
                    buf.append("\n");
                    continue block35;
                }
                case 10: {
                    int idx = this.getInstructionArg(i, 0);
                    String name = this.cfg.getName(idx);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(name);
                    buf.append("\n");
                    continue block35;
                }
                case 11: {
                    int idx = this.getInstructionArg(i, 0);
                    int dims = this.getInstructionArg(i, 1);
                    String name = this.cfg.getName(idx);
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append(" ");
                    buf.append(name);
                    buf.append(" ");
                    buf.append(dims);
                    buf.append("\n");
                    continue block35;
                }
                case 99: {
                    buf.append(OpcodesHelper.insnName(opcode));
                    buf.append("!!!\n");
                }
            }
        }
        if (this.activeTryStarts != null) {
            for (TryCatchDetails details : this.activeTryStarts) {
                Label label = details.getStart();
                BBlock block = this.cfg.getBlock(label);
                buf.append("try: ");
                if (block != null) {
                    buf.append(label.getOffset());
                    buf.append(" ");
                    buf.append(block.getBlockIdx());
                    buf.append(".");
                    buf.append(this.cfg.getBlockInstructionIdx(label));
                } else {
                    buf.append(label);
                }
                buf.append(" catch: ");
                label = details.getEnd();
                block = this.cfg.getBlock(label);
                if (block != null) {
                    buf.append(label.getOffset());
                    buf.append(" ");
                    buf.append(block.getBlockIdx());
                    buf.append(".");
                    buf.append(this.cfg.getBlockInstructionIdx(label));
                } else {
                    buf.append(label);
                }
                buf.append(" handle: ");
                label = details.getHandler();
                block = this.cfg.getBlock(label);
                if (block != null) {
                    buf.append(label.getOffset());
                    buf.append(" ");
                    buf.append(block.getBlockIdx());
                    buf.append(".");
                    buf.append(this.cfg.getBlockInstructionIdx(label));
                } else {
                    buf.append(label);
                }
                buf.append(" ");
                buf.append(details.getType());
                buf.append("\n");
            }
        }
    }
}

