/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.btxn;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;

public class BusinessTransaction {
    @JsonInclude
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name;
    @JsonInclude
    private List<Node> nodes = new ArrayList<Node>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> properties = new HashMap<String, String>();

    public String getId() {
        return this.id;
    }

    public BusinessTransaction setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public BusinessTransaction setNodes(List<Node> nodes) {
        this.nodes = nodes;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public BusinessTransaction setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public long startTime() {
        long ret = 0L;
        if (this.getNodes().size() > 0) {
            ret = this.getNodes().get(0).getStartTime();
        }
        return ret;
    }

    public long endTime() {
        long ret = 0L;
        for (Node node : this.getNodes()) {
            long endTime = node.overallEndTime();
            if (endTime <= ret) continue;
            ret = endTime;
        }
        return ret;
    }

    public Set<Node> getCorrelatedNodes(CorrelationIdentifier cid, long baseTime) {
        HashSet<Node> ret = new HashSet<Node>();
        for (Node n : this.getNodes()) {
            n.findCorrelatedNodes(cid, baseTime, ret);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusinessTransaction other = (BusinessTransaction)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "BusinessTransaction [id=" + this.id + ", name=" + this.name + ", nodes=" + this.nodes + ", properties=" + this.properties + "]";
    }
}

