/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.admin.BusinessTxnConfig;
import org.hawkular.btm.api.model.admin.CollectorConfiguration;
import org.hawkular.btm.api.model.admin.Processor;
import org.hawkular.btm.api.model.admin.ProcessorAction;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.NodeType;
import org.hawkular.btm.api.model.btxn.Service;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class ProcessorManager {
    private static Logger log = Logger.getLogger(ProcessorManager.class.getName());
    private Map<String, List<ProcessorWrapper>> processors = new HashMap<String, List<ProcessorWrapper>>();

    public ProcessorManager(CollectorConfiguration config) {
        this.init(config);
    }

    protected void init(CollectorConfiguration config) {
        for (String btxn : config.getBusinessTransactions().keySet()) {
            BusinessTxnConfig btc = config.getBusinessTransactions().get(btxn);
            if (log.isLoggable(Logger.Level.FINE)) {
                log.fine("ProcessManager: initialise btxn '" + btxn + "' config=" + btc + " processors=" + btc.getProcessors().size());
            }
            if (btc.getProcessors() == null || btc.getProcessors().isEmpty()) continue;
            ArrayList<ProcessorWrapper> procs = new ArrayList<ProcessorWrapper>();
            for (int i = 0; i < btc.getProcessors().size(); ++i) {
                procs.add(new ProcessorWrapper(btc.getProcessors().get(i)));
            }
            this.processors.put(btxn, procs);
        }
    }

    public void process(BusinessTransaction btxn, Node node, boolean req, Map<String, ?> headers, Object ... values) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("ProcessManager: process btxn=" + btxn + " node=" + node + " req=" + req + " headers=" + headers + " values=" + values + " : available processors=" + this.processors);
        }
        if (btxn.getName() != null && this.processors.containsKey(btxn.getName())) {
            List<ProcessorWrapper> procs = this.processors.get(btxn.getName());
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("ProcessManager: btxn name=" + btxn.getName() + " processors=" + procs);
            }
            for (int i = 0; i < procs.size(); ++i) {
                procs.get(i).process(btxn, node, req, headers, values);
            }
        }
    }

    public class ProcessorActionWrapper {
        private ProcessorAction action;
        private Object compiledPredicate = null;
        private Object compiledAction = null;

        public ProcessorActionWrapper(ProcessorAction action) {
            this.action = action;
            this.init();
        }

        protected void init() {
            try {
                ParserContext ctx = new ParserContext();
                ctx.addPackageImport("org.hawkular.btm.client.collector.internal.helpers");
                if (this.action.getPredicate() != null) {
                    this.compiledPredicate = MVEL.compileExpression(this.action.getPredicate(), ctx);
                    if (this.compiledPredicate == null) {
                        log.severe("Failed to compile predicate '" + this.action.getPredicate() + "'");
                    } else if (log.isLoggable(Logger.Level.FINE)) {
                        log.fine("Initialised processor predicate '" + this.action.getPredicate() + "' = " + this.compiledPredicate);
                    }
                }
                if (this.action.getExpression() != null) {
                    this.compiledAction = MVEL.compileExpression(this.action.getExpression(), ctx);
                    if (this.compiledAction == null) {
                        log.severe("Failed to compile action '" + this.action.getExpression() + "'");
                    } else if (log.isLoggable(Logger.Level.FINE)) {
                        log.fine("Initialised processor action '" + this.action.getExpression() + "' = " + this.compiledAction);
                    }
                } else {
                    log.severe("No action expression defined for processor action=" + this.action);
                }
            }
            catch (Throwable t) {
                log.log(Logger.Level.SEVERE, "Failed to compile processor predicate '" + this.action.getPredicate() + "' or action '" + this.action.getExpression() + "'", t);
            }
        }

        public void process(BusinessTransaction btxn, Node node, boolean req, Map<String, ?> headers, Object[] values) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("ProcessManager/Processor/Action[" + this.action + "]: process btxn=" + btxn + " node=" + node + " req=" + req + " headers=" + headers + " values=" + values);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        log.finest("        [value " + i + "] = " + values[i]);
                    }
                }
            }
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("btxn", btxn);
            vars.put("node", node);
            vars.put("headers", headers);
            vars.put("values", values);
            if (this.compiledPredicate != null && !((Boolean)MVEL.executeExpression(this.compiledPredicate, vars)).booleanValue()) {
                return;
            }
            Object result = MVEL.executeExpression(this.compiledAction, vars);
            if (this.action.getActionType() != null) {
                if (result == null) {
                    log.warning("Result for action type '" + (Object)((Object)this.action.getActionType()) + "' and action '" + this.action.getExpression() + "' was null");
                } else {
                    String value = null;
                    if (result.getClass() != String.class) {
                        if (log.isLoggable(Logger.Level.FINEST)) {
                            log.finest("Converting result for action type '" + (Object)((Object)this.action.getActionType()) + "' and action '" + this.action.getExpression() + "' to a String, was: " + result.getClass());
                        }
                        value = result.toString();
                    } else {
                        value = (String)result;
                    }
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("ProcessManager/Processor/Action: value=" + value);
                    }
                    switch (this.action.getActionType()) {
                        case SetDetail: {
                            node.getDetails().put(this.action.getName(), value);
                            break;
                        }
                        case SetFault: {
                            node.setFault(value);
                            break;
                        }
                        case AddContent: {
                            if (node.interactionNode()) {
                                if (req) {
                                    ((InteractionNode)node).getRequest().addContent(this.action.getName(), this.action.getType(), value);
                                    break;
                                }
                                ((InteractionNode)node).getResponse().addContent(this.action.getName(), this.action.getType(), value);
                                break;
                            }
                            log.warning("Attempt to add content to a non-interaction based node type '" + (Object)((Object)node.getType()) + "'");
                            break;
                        }
                        case SetProperty: {
                            btxn.getProperties().put(this.action.getName(), value);
                            break;
                        }
                        case AddCorrelationId: {
                            node.getCorrelationIds().add(new CorrelationIdentifier(this.action.getScope(), value));
                            break;
                        }
                        default: {
                            log.warning("Unhandled action type '" + (Object)((Object)this.action.getActionType()) + "'");
                        }
                    }
                }
            }
        }
    }

    public class ProcessorWrapper {
        private Processor processor;
        private Predicate<String> uriFilter = null;
        private Predicate<String> faultFilter = null;
        private List<ProcessorActionWrapper> actions = new ArrayList<ProcessorActionWrapper>();

        public ProcessorWrapper(Processor processor) {
            this.processor = processor;
            this.init();
        }

        protected void init() {
            if (this.processor.getUriFilter() != null) {
                this.uriFilter = Pattern.compile(this.processor.getUriFilter()).asPredicate();
            }
            if (this.processor.getFaultFilter() != null) {
                this.faultFilter = Pattern.compile(this.processor.getFaultFilter()).asPredicate();
            }
            for (int i = 0; i < this.processor.getActions().size(); ++i) {
                this.actions.add(new ProcessorActionWrapper(this.processor.getActions().get(i)));
            }
        }

        public void process(BusinessTransaction btxn, Node node, boolean req, Map<String, ?> headers, Object[] values) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("ProcessManager/Processor: process btxn=" + btxn + " node=" + node + " req=" + req + " headers=" + headers + " values=" + values);
            }
            if (this.processor.getNodeType() == node.getType() && this.processor.isRequest() == req) {
                if (this.uriFilter != null && !this.uriFilter.test(node.getUri())) {
                    return;
                }
                if (this.processor.getOperation() != null && node.getType() == NodeType.Service && !this.processor.getOperation().equals(((Service)node).getOperation())) {
                    return;
                }
                if (this.faultFilter == null && node.getFault() != null) {
                    return;
                }
                if (!(this.faultFilter == null || node.getFault() != null && this.faultFilter.test(node.getFault()))) {
                    return;
                }
                for (int i = 0; i < this.actions.size(); ++i) {
                    this.actions.get(i).process(btxn, node, req, headers, values);
                }
            }
        }
    }
}

