/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.admin;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.admin.BusinessTxnConfig;
import org.hawkular.btm.api.model.admin.Instrumentation;

public class CollectorConfiguration {
    private static final Logger log = Logger.getLogger(CollectorConfiguration.class.getName());
    @JsonInclude
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonInclude
    private Map<String, Instrumentation> instrumentation = new HashMap<String, Instrumentation>();
    @JsonInclude
    private Map<String, BusinessTxnConfig> businessTransactions = new HashMap<String, BusinessTxnConfig>();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getProperty(String name, String def) {
        String ret = def;
        if (System.getProperties().containsKey(name)) {
            ret = System.getProperty(name);
        } else if (this.getProperties().containsKey(name)) {
            ret = this.getProperties().get(name);
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get property '" + name + "' (default=" + def + ") = " + ret);
        }
        return ret;
    }

    public Map<String, Instrumentation> getInstrumentation() {
        return this.instrumentation;
    }

    public void setInstrumentation(Map<String, Instrumentation> instrumentation) {
        this.instrumentation = instrumentation;
    }

    public Map<String, BusinessTxnConfig> getBusinessTransactions() {
        return this.businessTransactions;
    }

    public void setBusinessTransactions(Map<String, BusinessTxnConfig> businessTransactions) {
        this.businessTransactions = businessTransactions;
    }

    public void merge(CollectorConfiguration config, boolean overwrite) throws IllegalArgumentException {
        for (String key : config.getInstrumentation().keySet()) {
            if (this.getInstrumentation().containsKey(key) && !overwrite) {
                throw new IllegalArgumentException("Instrumentation for '" + key + "' already exists");
            }
            this.getInstrumentation().put(key, config.getInstrumentation().get(key));
        }
        for (String key : config.getBusinessTransactions().keySet()) {
            if (this.getBusinessTransactions().containsKey(key) && !overwrite) {
                throw new IllegalArgumentException("Business Transaction config for '" + key + "' already exists");
            }
            this.getBusinessTransactions().put(key, config.getBusinessTransactions().get(key));
        }
        this.getProperties().putAll(config.getProperties());
    }
}

