/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.model.btxn;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hawkular.btm.api.model.btxn.Component;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.NodeType;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=InteractionNode.class), @JsonSubTypes.Type(value=Component.class)})
@ApiModel(parent=Node.class, subTypes={InteractionNode.class, Component.class}, discriminator="type")
public abstract class ContainerNode
extends Node {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Node> nodes = new ArrayList<Node>();

    public ContainerNode(NodeType type) {
        super(type);
    }

    public ContainerNode(NodeType type, String uri) {
        super(type, uri);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    @Override
    protected long overallEndTime() {
        long ret = super.overallEndTime();
        for (Node child : this.nodes) {
            long childEndTime = child.overallEndTime();
            if (childEndTime <= ret) continue;
            ret = childEndTime;
        }
        return ret;
    }

    @Override
    protected void findCorrelatedNodes(CorrelationIdentifier cid, long baseTime, Set<Node> nodes) {
        super.findCorrelatedNodes(cid, baseTime, nodes);
        for (Node child : this.getNodes()) {
            child.findCorrelatedNodes(cid, baseTime, nodes);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerNode other = (ContainerNode)obj;
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }
}

