/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class StringLiteral
extends Expression {
    private String text;

    public StringLiteral(Rule rule, ParseNode token) {
        super(rule, Type.STRING, token);
        String string = (String)token.getChild(0);
        this.text = string.intern();
    }

    @Override
    public void bind() {
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        if (!(expected.isUndefined() || expected.isVoid() || expected.isAssignableFrom(Type.STRING))) {
            throw new TypeException("StringLiteral.typeCheck : invalid expected type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return this.text;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        mv.visitLdcInsn(this.text);
        compileContext.addStackCount(1);
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write("\"");
        stringWriter.write(this.text);
        stringWriter.write("\"");
    }
}

