/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;

public class BusinessTransactionCriteria {
    private final Logger log = Logger.getLogger(BusinessTransactionCriteria.class.getName());
    private long startTime = 0L;
    private long endTime = 0L;
    private String name;
    private Map<String, String> properties = new HashMap<String, String>();
    private Set<CorrelationIdentifier> correlationIds = new HashSet<CorrelationIdentifier>();
    private static int DEFAULT_RESPONSE_SIZE = 100000;
    private static long DEFAULT_TIMEOUT = 10000L;
    private long timeout = DEFAULT_TIMEOUT;
    private int maxResponseSize = DEFAULT_RESPONSE_SIZE;

    public long getStartTime() {
        return this.startTime;
    }

    public BusinessTransactionCriteria setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public BusinessTransactionCriteria setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BusinessTransactionCriteria setName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public BusinessTransactionCriteria setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public Set<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public BusinessTransactionCriteria setCorrelationIds(Set<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public boolean isValid(BusinessTransaction btxn) {
        if (this.startTime > 0L && btxn.getStartTime() < this.startTime) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Start time out of range");
            }
            return false;
        }
        if (this.endTime > 0L && btxn.getStartTime() > this.endTime) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("End time out of range");
            }
            return false;
        }
        if (this.name != null) {
            if (this.name.trim().length() == 0) {
                if (btxn.getName() != null) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Name is defined");
                    }
                    return false;
                }
            } else if (!this.name.equals(btxn.getName())) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Name mismatch, was '" + btxn.getName() + "' required '" + this.name + "'");
                }
                return false;
            }
        }
        if (!this.properties.isEmpty()) {
            for (String key : this.properties.keySet()) {
                String value = this.properties.get(key);
                String result = btxn.getProperties().get(key);
                if (result != null && value.equals(result)) continue;
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Property '" + key + "' had value '" + result + "', expected '" + value + "'");
                }
                return false;
            }
        }
        if (!this.correlationIds.isEmpty()) {
            for (CorrelationIdentifier ci : this.correlationIds) {
                Set<Node> nodes = btxn.getCorrelatedNodes(ci);
                if (nodes.isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Map<String, String> parameters() {
        StringBuilder buf;
        boolean first;
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.getName() != null) {
            ret.put("name", this.getName());
        }
        if (this.getStartTime() > 0L) {
            ret.put("startTime", "" + this.getStartTime());
        }
        if (this.getEndTime() > 0L) {
            ret.put("endTime", "" + this.getEndTime());
        }
        if (!this.getProperties().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (String key : this.getProperties().keySet()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(key);
                buf.append('|');
                buf.append(this.getProperties().get(key));
            }
            ret.put("properties", buf.toString());
        }
        if (!this.getCorrelationIds().isEmpty()) {
            first = true;
            buf = new StringBuilder();
            for (CorrelationIdentifier cid : this.getCorrelationIds()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(cid.getScope().name());
                buf.append('|');
                buf.append(cid.getValue());
            }
            ret.put("correlations", buf.toString());
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Criteria parameters [" + ret + "]");
        }
        return ret;
    }

    public String toString() {
        return "BusinessTransactionCriteria [startTime=" + this.startTime + ", endTime=" + this.endTime + ", name=" + this.name + ", properties=" + this.properties + ", correlationIds=" + this.correlationIds + "]";
    }
}

