/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Component;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Message;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.NodeType;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.ReportingLevel;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.services.BusinessTransactionPublisher;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.api.services.ServiceResolver;
import org.hawkular.btm.client.api.BusinessTransactionCollector;
import org.hawkular.btm.client.api.SessionManager;
import org.hawkular.btm.client.collector.internal.BusinessTransactionReporter;
import org.hawkular.btm.client.collector.internal.FilterManager;
import org.hawkular.btm.client.collector.internal.FilterProcessor;
import org.hawkular.btm.client.collector.internal.FragmentBuilder;
import org.hawkular.btm.client.collector.internal.FragmentManager;
import org.hawkular.btm.client.collector.internal.ProcessorManager;

public class DefaultBusinessTransactionCollector
implements BusinessTransactionCollector,
SessionManager {
    private static final Logger log = Logger.getLogger(DefaultBusinessTransactionCollector.class.getName());
    private FragmentManager fragmentManager = new FragmentManager();
    private FilterManager filterManager;
    private ProcessorManager processorManager;
    private BusinessTransactionReporter reporter = new BusinessTransactionReporter();
    private Map<String, FragmentBuilder> correlations = new ConcurrentHashMap<String, FragmentBuilder>();
    private static final Logger.Level warningLogLevel = Logger.Level.WARNING;
    private long configLastUpdated = 0L;
    private static boolean testMode = Boolean.getBoolean("hawkular-btm.test.mode");

    public DefaultBusinessTransactionCollector() {
        CompletableFuture<ConfigurationService> asFuture = ServiceResolver.getSingletonService(ConfigurationService.class);
        asFuture.whenComplete((BiConsumer)new BiConsumer<ConfigurationService, Throwable>(){

            @Override
            public void accept(ConfigurationService cs, Throwable t) {
                if (t != null) {
                    log.log(Logger.Level.SEVERE, "Failed to obtain configuration service", t);
                }
                DefaultBusinessTransactionCollector.this.setConfigurationService(cs);
            }
        });
    }

    public void setConfigurationService(final ConfigurationService cs) {
        CollectorConfiguration config = cs.getCollector(null, null, null);
        if (log.isLoggable(Logger.Level.FINER)) {
            log.finer("Set configuration service = " + cs);
        }
        if (config != null) {
            block6: {
                this.configLastUpdated = System.currentTimeMillis();
                this.filterManager = new FilterManager(config);
                this.reporter.init(config);
                try {
                    this.processorManager = new ProcessorManager(config);
                }
                catch (Throwable t) {
                    if (t == null) break block6;
                    log.log(Logger.Level.SEVERE, "Failed to initialise Process Manager", t);
                }
            }
            Integer refresh = Integer.getInteger("hawkular-btm.config.refresh");
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Configuration refresh cycle (in seconds) = " + refresh);
            }
            if (refresh != null) {
                Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Map<String, BusinessTxnConfig> changed = cs.getBusinessTransactions(null, DefaultBusinessTransactionCollector.this.configLastUpdated);
                            for (String btxn : changed.keySet()) {
                                BusinessTxnConfig btc = changed.get(btxn);
                                if (btc.isDeleted()) {
                                    if (log.isLoggable(Logger.Level.FINER)) {
                                        log.finer("Removing config for btxn '" + btxn + "' = " + btc);
                                    }
                                    DefaultBusinessTransactionCollector.this.filterManager.remove(btxn);
                                    DefaultBusinessTransactionCollector.this.processorManager.remove(btxn);
                                } else {
                                    if (log.isLoggable(Logger.Level.FINER)) {
                                        log.finer("Changed config for btxn '" + btxn + "' = " + btc);
                                    }
                                    DefaultBusinessTransactionCollector.this.filterManager.init(btxn, btc);
                                    DefaultBusinessTransactionCollector.this.processorManager.init(btxn, btc);
                                }
                                if (btc.getLastUpdated() <= DefaultBusinessTransactionCollector.this.configLastUpdated) continue;
                                DefaultBusinessTransactionCollector.this.configLastUpdated = btc.getLastUpdated();
                            }
                        }
                        catch (Exception e) {
                            log.log(Logger.Level.SEVERE, "Failed to update business transaction configuration", e);
                        }
                    }
                }, refresh.intValue(), refresh.intValue(), TimeUnit.SECONDS);
            }
        }
    }

    public BusinessTransactionPublisher getBusinessTransactionPublisher() {
        return this.reporter.getBusinessTransactionPublisher();
    }

    public void setBusinessTransactionPublisher(BusinessTransactionPublisher businessTransactionPublisher) {
        this.reporter.setBusinessTransactionPublisher(businessTransactionPublisher);
    }

    public String getTenantId() {
        return this.reporter.getTenantId();
    }

    public void setTenantId(String tenantId) {
        this.reporter.setTenantId(tenantId);
    }

    @Override
    public void setName(String location, String name) {
        block8: {
            if (name == null || name.trim().isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Ignoring attempt to set business transaction name to null");
                }
                return;
            }
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set business transaction location=[" + location + "] name=" + name);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getBusinessTransaction().setName(name);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "setName: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block8;
                log.log(warningLogLevel, "setName failed", t);
            }
        }
    }

    @Override
    public String getName() {
        String ret;
        block7: {
            ret = null;
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    ret = builder.getBusinessTransaction().getName();
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "getName: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "getName failed", t);
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get business transaction name=" + ret);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    @Override
    public void setLevel(String location, String level) {
        block9: {
            if (level == null || level.trim().isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Ignoring attempt to set level to null");
                }
                return;
            }
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set reporting level: location=[" + location + "] level=" + level);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    if (builder != null) {
                        builder.setLevel(ReportingLevel.valueOf(level));
                    } else if (log.isLoggable(warningLogLevel)) {
                        log.log(warningLogLevel, "setLevel: No fragment builder for this thread", null);
                    }
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block9;
                log.log(warningLogLevel, "setLevel failed", t);
            }
        }
    }

    @Override
    public String getLevel() {
        String ret;
        block7: {
            ret = null;
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    ret = builder.getLevel().name();
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "getLevel: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "getLevel failed", t);
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Get level=" + ret);
        }
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    @Override
    public void consumerStart(String location, String uri, String type, String id) {
        block5: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Consumer start: location=[" + location + "] type=" + type + " uri=" + uri + " id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Consumer consumer = new Consumer();
                    consumer.setEndpointType(type);
                    consumer.setUri(uri);
                    if (id != null) {
                        consumer.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
                    }
                    this.push(location, builder, consumer);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block5;
                log.log(warningLogLevel, "consumerStart failed", t);
            }
        }
    }

    @Override
    public void consumerEnd(String location, String uri, String type) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Consumer end: location=[" + location + "] type=" + type + " uri=" + uri);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Consumer node = this.pop(location, builder, Consumer.class, uri);
                    this.checkForCompletion(builder, node);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "consumerEnd: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "consumerEnd failed", t);
            }
        }
    }

    @Override
    public void componentStart(String location, String uri, String type, String operation) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Component start: location=[" + location + "] type=" + type + " operation=" + operation + " uri=" + uri);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Component component = new Component();
                    component.setComponentType(type);
                    component.setUri(uri);
                    component.setOperation(operation);
                    this.push(location, builder, component);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "componentStart failed", t);
            }
        }
    }

    @Override
    public void componentEnd(String location, String uri, String type, String operation) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Component end: location=[" + location + "] type=" + type + " operation=" + operation + " uri=" + uri);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Component node = this.pop(location, builder, Component.class, uri);
                    this.checkForCompletion(builder, node);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "componentEnd: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "componentEnd failed", t);
            }
        }
    }

    @Override
    public void producerStart(String location, String uri, String type, String id) {
        block5: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Producer start: location=[" + location + "] type=" + type + " uri=" + uri + " id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Producer producer = new Producer();
                    producer.setEndpointType(type);
                    producer.setUri(uri);
                    if (id != null) {
                        producer.getCorrelationIds().add(new CorrelationIdentifier(CorrelationIdentifier.Scope.Interaction, id));
                    }
                    this.push(location, builder, producer);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block5;
                log.log(warningLogLevel, "producerStart failed", t);
            }
        }
    }

    @Override
    public void producerEnd(String location, String uri, String type) {
        block7: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Producer end: location=[" + location + "] type=" + type + " uri=" + uri);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Producer node = this.pop(location, builder, Producer.class, uri);
                    Node current = builder.getCurrentNode();
                    if (current != null && current.getType() == NodeType.Producer) {
                        this.mergeProducer(node, (Producer)current);
                    }
                    this.checkForCompletion(builder, node);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "producerEnd: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "producerEnd failed", t);
            }
        }
    }

    protected void mergeProducer(Producer inner, Producer outer) {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Merging Producer = " + inner + " into Producer = " + outer);
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Merging Producers: replacing correlation ids (" + outer.getCorrelationIds() + ") with (" + inner.getCorrelationIds() + ")");
        }
        outer.setCorrelationIds(inner.getCorrelationIds());
        outer.getNodes().remove(inner);
    }

    @Override
    public boolean isInProcessed(String location) {
        block7: {
            if (testMode && !Boolean.getBoolean("hawkular-btm.test.process.headers") && !Boolean.getBoolean("hawkular-btm.test.process.content")) {
                return false;
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    Node node = builder.getCurrentNode();
                    if (node != null && node.interactionNode()) {
                        return this.processorManager.isProcessed(builder.getBusinessTransaction(), node, Direction.In);
                    }
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "isInProcessed: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "isInProcessed failed", t);
            }
        }
        return false;
    }

    @Override
    public boolean isInContentProcessed(String location) {
        block7: {
            if (testMode && !Boolean.getBoolean("hawkular-btm.test.process.content")) {
                return false;
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    Node node = builder.getCurrentNode();
                    if (node != null && node.interactionNode()) {
                        return this.processorManager.isContentProcessed(builder.getBusinessTransaction(), node, Direction.In);
                    }
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "isInContentProcessed: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "isInContentProcessed failed", t);
            }
        }
        return false;
    }

    @Override
    public boolean isOutProcessed(String location) {
        block7: {
            if (testMode && !Boolean.getBoolean("hawkular-btm.test.process.headers") && !Boolean.getBoolean("hawkular-btm.test.process.content")) {
                return false;
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    Node node = builder.getCurrentNode();
                    if (node != null && node.interactionNode()) {
                        return this.processorManager.isProcessed(builder.getBusinessTransaction(), node, Direction.Out);
                    }
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "isOutProcessed: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "isOutProcessed failed", t);
            }
        }
        return false;
    }

    @Override
    public boolean isOutContentProcessed(String location) {
        block7: {
            if (testMode && !Boolean.getBoolean("hawkular-btm.test.process.content")) {
                return false;
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    Node node = builder.getCurrentNode();
                    if (node != null && node.interactionNode()) {
                        return this.processorManager.isContentProcessed(builder.getBusinessTransaction(), node, Direction.Out);
                    }
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "isOutContentProcessed: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "isOutContentProcessed failed", t);
            }
        }
        return false;
    }

    @Override
    public void processIn(String location, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Process in: location=[" + location + "] headers=" + headers + " values=" + values);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    this.processValues(builder.getBusinessTransaction(), builder.getCurrentNode(), Direction.In, headers, values);
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("processIn: No fragment builder available to process the in data");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "processIn failed", t);
            }
        }
    }

    @Override
    public void processOut(String location, Map<String, ?> headers, Object ... values) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Process out: location=[" + location + "] headers=" + headers + " values=" + values);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    this.processValues(builder.getBusinessTransaction(), builder.getCurrentNode(), Direction.Out, headers, values);
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("processOut: No fragment builder available to process the out data");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "processOut failed", t);
            }
        }
    }

    @Override
    public void setFault(String location, String value, String description) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set fault: location=[" + location + "] value=" + value + " description=" + description);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    builder.getCurrentNode().setFault(value).setFaultDescription(description);
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "setFault: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "setFault failed", t);
            }
        }
    }

    @Override
    public void setProperty(String location, String name, String value) {
        block8: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set business transaction property: location=" + location + " name=" + name + " value=" + value);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    if (value == null) {
                        builder.getBusinessTransaction().getProperties().remove(name);
                    } else {
                        builder.getBusinessTransaction().getProperties().put(name, value);
                    }
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "setProperty: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block8;
                log.log(warningLogLevel, "setProperty failed", t);
            }
        }
    }

    @Override
    public void setDetail(String location, String name, String value, String nodeType, boolean onStack) {
        block12: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Set node detail: location=[" + location + "] name=" + name + " value=" + value + " nodeType=" + nodeType + " onStack=" + onStack);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    Node node = null;
                    node = nodeType == null ? builder.getCurrentNode() : builder.getLatestNode(nodeType, onStack);
                    if (node != null) {
                        if (log.isLoggable(Logger.Level.FINEST)) {
                            log.finest("Set node details: using node=" + node);
                        }
                        if (value == null) {
                            node.getDetails().remove(name);
                        } else {
                            node.getDetails().put(name, value);
                        }
                    } else if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Set node details: failed to find node to set");
                    }
                } else if (log.isLoggable(warningLogLevel)) {
                    log.log(warningLogLevel, "setDetail: No fragment builder for this thread", null);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block12;
                log.log(warningLogLevel, "setDetail failed", t);
            }
        }
    }

    @Override
    public void initInBuffer(String location, Object obj) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("initInBuffer: location=[" + location + "] obj=" + obj);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    builder.initInBuffer(this.getCode(obj));
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("initInBuffer: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "initInBuffer failed", t);
            }
        }
    }

    protected int getCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    @Override
    public boolean isInBufferActive(String location, Object obj) {
        block5: {
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    boolean ret = builder.isInBufferActive(this.getCode(obj));
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("isInBufferActive: location=[" + location + "] obj=" + obj + "? " + ret);
                    }
                    return ret;
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("isInBufferActive: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block5;
                log.log(warningLogLevel, "isInBufferActive failed", t);
            }
        }
        return false;
    }

    @Override
    public void appendInBuffer(String location, Object obj, byte[] data, int offset, int len) {
        block7: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("appendInBuffer: location=[" + location + "] obj=" + obj + " data=" + data + " offset=" + offset + " len=" + len);
            }
            if (len == -1) {
                return;
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    builder.writeInData(this.getCode(obj), data, offset, len);
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("appendInBuffer: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "appendInBuffer failed", t);
            }
        }
    }

    @Override
    public void recordInBuffer(String location, Object obj) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("recordInBuffer: location=[" + location + "] obj=" + obj);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    this.processInContent(location, this.fragmentManager.getFragmentBuilder(), this.getCode(obj));
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("recordInBuffer: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "recordInBuffer failed", t);
            }
        }
    }

    protected void processInContent(String location, FragmentBuilder builder, int hashCode) {
        if (builder.isInBufferActive(hashCode)) {
            this.processIn(location, null, new Object[]{builder.getInData(hashCode)});
        } else if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("processInContent: location=[" + location + "] hashCode=" + hashCode + " in buffer is not active");
        }
    }

    @Override
    public void initOutBuffer(String location, Object obj) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("initOutBuffer: location=[" + location + "] obj=" + obj);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    builder.initOutBuffer(this.getCode(obj));
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("initOutBuffer: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "initOutBuffer failed", t);
            }
        }
    }

    @Override
    public boolean isOutBufferActive(String location, Object obj) {
        block5: {
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    boolean ret = builder.isOutBufferActive(this.getCode(obj));
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("isOutBufferActive: location=[" + location + "] obj=" + obj + "? " + ret);
                    }
                    return ret;
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("isOutBufferActive: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block5;
                log.log(warningLogLevel, "isOutBufferActive failed", t);
            }
        }
        return false;
    }

    @Override
    public void appendOutBuffer(String location, Object obj, byte[] data, int offset, int len) {
        block7: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("appendOutBuffer: location=[" + location + "] obj=" + obj + " data=" + data + " offset=" + offset + " len=" + len);
            }
            if (len == -1) {
                return;
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                    builder.writeOutData(this.getCode(obj), data, offset, len);
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("appendOutBuffer: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block7;
                log.log(warningLogLevel, "appendOutBuffer failed", t);
            }
        }
    }

    @Override
    public void recordOutBuffer(String location, Object obj) {
        block6: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("recordOutBuffer: location=[" + location + "] obj=" + obj);
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    this.processOutContent(location, this.fragmentManager.getFragmentBuilder(), this.getCode(obj));
                } else if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("recordOutBuffer: No fragment builder for this thread");
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block6;
                log.log(warningLogLevel, "recordOutBuffer failed", t);
            }
        }
    }

    protected void processOutContent(String location, FragmentBuilder builder, int hashCode) {
        if (builder.isOutBufferActive(hashCode)) {
            this.processOut(location, null, new Object[]{builder.getOutData(hashCode)});
        } else if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("processOutContent: location=[" + location + "] hashCode=" + hashCode + " out buffer is not active");
        }
    }

    protected void push(String location, FragmentBuilder builder, Node node) {
        this.processInContent(location, builder, -1);
        node.setBaseTime(System.nanoTime());
        builder.pushNode(node);
    }

    protected <T extends Node> T pop(String location, FragmentBuilder builder, Class<T> cls, String uri) {
        if (builder == null) {
            if (log.isLoggable(Logger.Level.WARNING)) {
                log.warning("No fragment builder for this thread (" + Thread.currentThread() + ") - trying to pop node of type: " + cls);
            }
            return null;
        }
        if (builder.getCurrentNode() == null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("WARNING: No 'current node' for this thread (" + Thread.currentThread() + ") - trying to pop node of type: " + cls);
            }
            return null;
        }
        this.processInContent(location, builder, -1);
        this.processOutContent(location, builder, -1);
        Node node = builder.popNode(cls, uri);
        if (node != null) {
            node.setDuration(System.nanoTime() - node.getBaseTime());
            return (T)((Node)cls.cast(node));
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Current node (type=" + builder.getCurrentNode().getClass() + ") does not match required cls=" + cls + " and uri=" + uri + " at location=" + location);
        }
        return null;
    }

    protected void processValues(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (node.interactionNode()) {
            Message m = null;
            if (direction == Direction.In) {
                m = ((InteractionNode)node).getIn();
                if (m == null) {
                    m = new Message();
                    ((InteractionNode)node).setIn(m);
                }
            } else {
                m = ((InteractionNode)node).getOut();
                if (m == null) {
                    m = new Message();
                    ((InteractionNode)node).setOut(m);
                }
            }
            if (headers != null && m.getHeaders().isEmpty()) {
                for (String key : headers.keySet()) {
                    String value = this.getHeaderValueText(headers.get(key));
                    if (value == null) continue;
                    m.getHeaders().put(key, value);
                }
            }
        }
        if (this.processorManager != null) {
            this.processorManager.process(btxn, node, direction, headers, values);
        }
    }

    protected String getHeaderValueText(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == String.class) {
            return (String)value;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 1) {
                return this.getHeaderValueText(list.get(0));
            }
            return list.toString();
        }
        return null;
    }

    protected void checkForCompletion(FragmentBuilder builder, Node node) {
        if (builder.isComplete()) {
            if (node != null) {
                BusinessTransaction btxn = builder.getBusinessTransaction();
                if (builder.getLevel().ordinal() <= ReportingLevel.None.ordinal()) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Not recording business transaction (level=" + (Object)((Object)builder.getLevel()) + "): " + btxn);
                    }
                } else if (btxn != null && !btxn.getNodes().isEmpty()) {
                    if (log.isLoggable(Logger.Level.FINEST)) {
                        log.finest("Record business transaction: " + btxn);
                    }
                    this.reporter.report(btxn);
                }
            }
            this.fragmentManager.clear();
            List<String> ids = builder.getUncompletedCorrelationIds();
            for (int i = 0; i < ids.size(); ++i) {
                this.correlations.remove(ids.get(i));
            }
            this.diagnostics();
        }
    }

    @Override
    public boolean activate(String uri) {
        return this.activate(uri, null);
    }

    @Override
    public boolean activate(String uri, String id) {
        if (id != null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("activate: ID not null, so fragment will be traced");
            }
            return true;
        }
        boolean active = this.isActive();
        FragmentBuilder builder = null;
        if (active) {
            BusinessTransaction btxn;
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("activate: Already active");
            }
            if ((btxn = (builder = this.fragmentManager.getFragmentBuilder()).getBusinessTransaction()).getName() != null || btxn.getNodes().size() > 0 && !btxn.getNodes().get(0).getCorrelationIds().isEmpty()) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("activate: Already active, with btxn name or top level node having correlation ids");
                }
                return true;
            }
        }
        if (uri != null) {
            if (this.filterManager == null) {
                if (log.isLoggable(Logger.Level.FINEST)) {
                    log.finest("Unable to determine if fragment should be traced due to missing filter manager");
                }
            } else {
                FilterProcessor filterProcessor = this.filterManager.getFilterProcessor(uri);
                if (filterProcessor != null && filterProcessor.getBusinessTransaction() != null) {
                    if (builder == null) {
                        builder = this.fragmentManager.getFragmentBuilder();
                    }
                    if (builder != null) {
                        builder.getBusinessTransaction().setName(filterProcessor.getBusinessTransaction());
                        builder.setLevel(filterProcessor.getConfig().getLevel());
                    }
                }
                if (log.isLoggable(Logger.Level.FINEST)) {
                    if (filterProcessor != null) {
                        log.finest("activate: URI[" + uri + "] business transaction name=" + filterProcessor.getBusinessTransaction() + " config=" + filterProcessor.getConfig());
                    } else {
                        log.finest("activate: URI[" + uri + "] no business transaction found");
                    }
                }
                return filterProcessor != null;
            }
        }
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("activate: No URI, so returning existing active state=" + active);
        }
        return active;
    }

    @Override
    public boolean isActive() {
        try {
            return this.fragmentManager.hasFragmentBuilder();
        }
        catch (Throwable t) {
            if (log.isLoggable(warningLogLevel)) {
                log.log(warningLogLevel, "isActive failed", t);
            }
            return false;
        }
    }

    @Override
    public void retainNode(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Retain node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.retainNode(id);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "retainNode failed", t);
            }
        }
    }

    @Override
    public void releaseNode(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Release node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    Node node = builder.releaseNode(id);
                    this.checkForCompletion(builder, node);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "releaseNode failed", t);
            }
        }
    }

    @Override
    public Node retrieveNode(String id) {
        Node ret;
        block4: {
            ret = null;
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Retrieve node: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    ret = builder.retrieveNode(id);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "retrieveNode failed", t);
            }
        }
        return ret;
    }

    @Override
    public void initiateCorrelation(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Initiate correlation: id=" + id);
            }
            try {
                FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
                if (builder != null) {
                    builder.getUncompletedCorrelationIds().add(id);
                    this.correlations.put(id, builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "initiateCorrelation failed", t);
            }
        }
    }

    @Override
    public boolean isCorrelated(String id) {
        boolean correlationActive = this.correlations.containsKey(id);
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Is correlated? id=" + id + " result=" + correlationActive);
        }
        return correlationActive;
    }

    @Override
    public void correlate(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Correlate: id=" + id);
            }
            try {
                FragmentBuilder builder = this.correlations.get(id);
                if (builder != null) {
                    this.fragmentManager.setFragmentBuilder(builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "correlate failed", t);
            }
        }
    }

    @Override
    public void completeCorrelation(String id) {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Complete correlation: id=" + id);
            }
            try {
                FragmentBuilder builder = this.correlations.get(id);
                if (builder != null) {
                    builder.getUncompletedCorrelationIds().remove(id);
                    this.correlations.remove(id);
                    this.fragmentManager.setFragmentBuilder(builder);
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "completeCorrelation failed", t);
            }
        }
    }

    @Override
    public void unlink() {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Unlink");
            }
            try {
                if (this.fragmentManager.hasFragmentBuilder()) {
                    this.fragmentManager.clear();
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "unlink failed", t);
            }
        }
    }

    @Override
    public void suppress() {
        FragmentBuilder builder = this.fragmentManager.getFragmentBuilder();
        if (builder != null) {
            builder.suppress();
        }
    }

    @Override
    public void assertComplete() {
        block4: {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Assert complete");
            }
            try {
                FragmentBuilder builder;
                if (this.fragmentManager.hasFragmentBuilder() && !(builder = this.fragmentManager.getFragmentBuilder()).isComplete()) {
                    log.severe("Business transaction has not completed: " + this.fragmentManager.getFragmentBuilder());
                }
            }
            catch (Throwable t) {
                if (!log.isLoggable(warningLogLevel)) break block4;
                log.log(warningLogLevel, "assertComplete failed", t);
            }
        }
    }

    @Override
    public SessionManager session() {
        return this;
    }

    protected FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    protected void diagnostics() {
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            log.finest("BTM COLLECTOR DIAGNOSTICS:");
            this.fragmentManager.diagnostics();
            log.finest("Correlation (" + this.correlations.size() + "): " + this.correlations);
            log.finest("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        }
    }
}

