/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal.actions;

import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.InteractionNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.AddContentAction;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.hawkular.btm.client.collector.internal.actions.ExpressionBasedActionHandler;

public class AddContentActionHandler
extends ExpressionBasedActionHandler {
    private static final Logger log = Logger.getLogger(AddContentActionHandler.class.getName());

    public AddContentActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public boolean process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        String value;
        if (super.process(btxn, node, direction, headers, values) && (value = this.getValue(btxn, node, direction, headers, values)) != null) {
            if (node.interactionNode()) {
                if (direction == Direction.In) {
                    ((InteractionNode)node).getIn().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                } else {
                    ((InteractionNode)node).getOut().addContent(((AddContentAction)this.getAction()).getName(), ((AddContentAction)this.getAction()).getType(), value);
                }
                return true;
            }
            log.warning("Attempt to add content to a non-interaction based node type '" + (Object)((Object)node.getType()) + "'");
        }
        return false;
    }
}

