/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.agent.HelperManager;
import org.jboss.byteman.agent.Location;
import org.jboss.byteman.agent.RuleScript;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.java_cup.runtime.Symbol;
import org.jboss.byteman.rule.Action;
import org.jboss.byteman.rule.Condition;
import org.jboss.byteman.rule.Event;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.compiler.Compiler;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.EarlyReturnException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.ParseException;
import org.jboss.byteman.rule.exception.ThrowException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.exception.TypeWarningException;
import org.jboss.byteman.rule.grammar.ECAGrammarParser;
import org.jboss.byteman.rule.grammar.ECATokenLexer;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.Helper;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.helper.InterpretedHelper;
import org.jboss.byteman.rule.type.Type;
import org.jboss.byteman.rule.type.TypeGroup;

public class Rule {
    private RuleScript ruleScript;
    private String name;
    private ClassLoader loader;
    private Event event;
    private Condition condition;
    private Action action;
    private Bindings bindings;
    private String triggerClass;
    private String triggerMethod;
    private String triggerDescriptor;
    private String[] triggerExceptions;
    private int triggerAccess;
    private TypeGroup typeGroup;
    private boolean checked;
    private boolean checkFailed;
    private Type returnType;
    private String key;
    private HelperManager helperManager;
    private List<Field> accessibleFields;
    private List<Method> accessibleMethods;
    private static HashMap<String, Rule> ruleKeyMap = new HashMap();
    private static int nextId = 0;
    private Class helperClass;
    private Class helperImplementationClass;
    private static boolean debugParse = System.getProperty("org.jboss.byteman.rule.debug") != null;

    private Rule(RuleScript ruleScript, ClassLoader loader, HelperManager helperManager) throws ParseException, TypeException, CompileException {
        ParseNode ruleTree;
        this.ruleScript = ruleScript;
        this.helperClass = null;
        this.loader = loader;
        this.typeGroup = new TypeGroup(loader);
        this.bindings = new Bindings();
        this.checked = false;
        this.triggerClass = null;
        this.triggerMethod = null;
        this.triggerDescriptor = null;
        this.triggerAccess = 0;
        this.returnType = null;
        this.accessibleFields = null;
        this.accessibleMethods = null;
        this.helperManager = helperManager;
        ECAGrammarParser parser = null;
        try {
            Symbol parse;
            String file = this.getFile();
            ECATokenLexer lexer = new ECATokenLexer(new StringReader(ruleScript.getRuleText()));
            lexer.setStartLine(this.getLine());
            lexer.setFile(file);
            parser = new ECAGrammarParser(lexer);
            parser.setFile(file);
            Symbol symbol = parse = debugParse ? parser.debug_parse() : parser.parse();
            if (parser.getErrorCount() != 0) {
                String message = "rule " + ruleScript.getName();
                message = message + parser.getErrors();
                throw new ParseException(message);
            }
            ruleTree = (ParseNode)parse.value;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Throwable th) {
            String message = "rule " + ruleScript.getName();
            if (parser != null && parser.getErrorCount() != 0) {
                message = message + parser.getErrors();
            }
            message = message + "\n" + th.getMessage();
            throw new ParseException(message);
        }
        ParseNode eventTree = (ParseNode)ruleTree.getChild(0);
        ParseNode conditionTree = (ParseNode)ruleTree.getChild(1);
        ParseNode actionTree = (ParseNode)ruleTree.getChild(2);
        this.event = Event.create(this, eventTree);
        this.condition = Condition.create(this, conditionTree);
        this.action = Action.create(this, actionTree);
        this.key = null;
    }

    public TypeGroup getTypeGroup() {
        return this.typeGroup;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public String getName() {
        return this.ruleScript.getName();
    }

    public String getTargetClass() {
        return this.ruleScript.getTargetClass();
    }

    public String getTargetMethod() {
        return this.ruleScript.getTargetMethod();
    }

    public Location getTargetLocation() {
        return this.ruleScript.getTargetLocation();
    }

    public boolean isOverride() {
        return this.ruleScript.isOverride();
    }

    public boolean isInterface() {
        return this.ruleScript.isInterface();
    }

    public int getLine() {
        return this.ruleScript.getLine();
    }

    public String getFile() {
        return this.ruleScript.getFile();
    }

    public Event getEvent() {
        return this.event;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Action getAction() {
        return this.action;
    }

    public String getTriggerClass() {
        return this.triggerClass;
    }

    public String getTriggerMethod() {
        return this.triggerMethod;
    }

    public String getTriggerDescriptor() {
        return this.triggerDescriptor;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public static Rule create(RuleScript ruleScript, ClassLoader loader, HelperManager helperManager) throws ParseException, TypeException, CompileException {
        return new Rule(ruleScript, loader, helperManager);
    }

    public void setEvent(String eventSpec) throws ParseException, TypeException {
        if (this.event == null) {
            this.event = Event.create(this, eventSpec);
        }
    }

    public void setCondition(String conditionSpec) throws ParseException, TypeException {
        if (this.event != null & this.condition == null) {
            this.condition = Condition.create(this, conditionSpec);
        }
    }

    public void setAction(String actionSpec) throws ParseException, TypeException {
        if (this.event != null & this.condition != null && this.action == null) {
            this.action = Action.create(this, actionSpec);
        }
    }

    public void setTypeInfo(String className, int access, String methodName, String desc, String[] exceptions) {
        this.triggerClass = className;
        this.triggerAccess = access;
        this.triggerMethod = methodName;
        this.triggerDescriptor = desc;
        this.triggerExceptions = exceptions;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isCheckFailed() {
        return this.checkFailed;
    }

    public boolean isCheckedOk() {
        return this.checked && !this.checkFailed;
    }

    public static boolean disableTriggersInternal() {
        return Transformer.disableTriggers(false);
    }

    public static boolean enableTriggersInternal() {
        return Transformer.enableTriggers(false);
    }

    public static boolean disableTriggers() {
        return Transformer.disableTriggers(true);
    }

    public static boolean enableTriggers() {
        return Transformer.enableTriggers(true);
    }

    public static boolean isTriggeringEnabled() {
        return Transformer.isTriggeringEnabled();
    }

    private synchronized boolean ensureTypeCheckedCompiled() {
        if (this.checkFailed) {
            return false;
        }
        if (!this.checked) {
            boolean triggerEnabled = false;
            String detail = "";
            try {
                this.typeCheck();
                this.compile();
                this.checked = true;
                this.installed();
            }
            catch (TypeWarningException te) {
                this.checkFailed = true;
                if (Transformer.isVerbose()) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(stringWriter);
                    writer.println("Rule.ensureTypeCheckedCompiled : warning type checking rule " + this.getName());
                    te.printStackTrace(writer);
                    detail = stringWriter.toString();
                    System.out.println(detail);
                }
            }
            catch (TypeException te) {
                this.checkFailed = true;
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                writer.println("Rule.ensureTypeCheckedCompiled : error type checking rule " + this.getName());
                te.printStackTrace(writer);
                detail = stringWriter.toString();
                System.out.println(detail);
            }
            catch (CompileException ce) {
                this.checkFailed = true;
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                writer.println("Rule.ensureTypeCheckedCompiled : error compiling rule " + this.getName());
                ce.printStackTrace(writer);
                detail = stringWriter.toString();
                System.out.println(detail);
            }
            this.ruleScript.recordCompile(this.triggerClass, this.loader, !this.checkFailed, detail);
            return !this.checkFailed;
        }
        return true;
    }

    public void typeCheck() throws TypeException {
        String helperName = this.ruleScript.getTargetHelper();
        if (helperName != null) {
            try {
                this.helperClass = this.loader.loadClass(helperName);
            }
            catch (ClassNotFoundException e) {
                throw new TypeException("Rule.typecheck : unknown helper class " + helperName + " for rule " + this.getName());
            }
        } else {
            this.helperClass = Helper.class;
        }
        if (this.triggerExceptions != null) {
            this.typeGroup.addExceptionTypes(this.triggerExceptions);
        }
        this.typeGroup.resolveTypes();
        this.installParameters((this.triggerAccess & 8) != 0, this.triggerClass);
        this.event.typeCheck(Type.VOID);
        this.condition.typeCheck(Type.Z);
        this.action.typeCheck(Type.VOID);
    }

    public void compile() throws CompileException {
        boolean compileToBytecode = this.isCompileToBytecode();
        this.helperImplementationClass = this.helperClass == Helper.class && !compileToBytecode ? InterpretedHelper.class : Compiler.getHelperAdapter(this, this.helperClass, compileToBytecode);
    }

    private boolean isCompileToBytecode() {
        return Transformer.isCompileToBytecode();
    }

    private void installParameters(boolean isStatic, String className) throws TypeException {
        Binding recipientBinding;
        Type type = this.typeGroup.create(this.helperClass.getName());
        Binding ruleBinding = this.bindings.lookup("$$");
        if (ruleBinding != null) {
            ruleBinding.setType(type);
        } else {
            this.bindings.append(new Binding(this, "$$", type));
        }
        if (!isStatic && (recipientBinding = this.bindings.lookup("$0")) != null) {
            type = this.typeGroup.create(className);
            if (type.isUndefined()) {
                throw new TypeException("Rule.installParameters : Rule " + this.name + " unable to load class " + className);
            }
            recipientBinding.setType(type);
        }
        String returnTypeName = Type.parseMethodReturnType(this.triggerDescriptor);
        this.returnType = this.typeGroup.create(returnTypeName);
        Iterator<Binding> iterator = this.bindings.iterator();
        while (iterator.hasNext()) {
            Binding binding = iterator.next();
            if (binding.isParam() || binding.isLocalVar() || binding.isReturn()) {
                Type baseType;
                String typeName = binding.getDescriptor();
                String[] typeAndArrayBounds = typeName.split("\\[");
                Type fullType = baseType = this.typeGroup.create(typeAndArrayBounds[0]);
                if (baseType.isUndefined()) {
                    throw new TypeException("Rule.installParameters : Rule " + this.name + " unable to load class " + baseType);
                }
                for (int i = 1; i < typeAndArrayBounds.length; ++i) {
                    fullType = this.typeGroup.createArray(fullType);
                }
                binding.setType(fullType);
                continue;
            }
            if (binding.isThrowable()) {
                binding.setType(this.typeGroup.ensureType(Throwable.class));
                continue;
            }
            if (binding.isParamCount()) {
                binding.setType(Type.I);
                continue;
            }
            if (binding.isParamArray() || binding.isInvokeParamArray()) {
                binding.setType(Type.OBJECT.arrayType());
                continue;
            }
            if (!binding.isTriggerClass() && !binding.isTriggerMethod()) continue;
            binding.setType(Type.STRING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String key, Object recipient, Object[] args) throws ExecuteException {
        boolean enabled = Rule.isTriggeringEnabled();
        if (!enabled) {
            return;
        }
        Rule.disableTriggersInternal();
        try {
            Rule rule = ruleKeyMap.get(key);
            if (Transformer.isVerbose()) {
                System.out.println("Rule.execute called for " + key);
            }
            if (rule == null) {
                if (Transformer.isVerbose()) {
                    System.out.println("Rule.execute for decommissioned key " + key);
                }
                return;
            }
            rule.execute(recipient, args);
        }
        finally {
            Rule.enableTriggers();
        }
    }

    private void execute(Object recipient, Object[] args) throws ExecuteException {
        if (this.ensureTypeCheckedCompiled()) {
            try {
                Constructor constructor = this.helperImplementationClass.getConstructor(Rule.class);
                HelperAdapter helper = (HelperAdapter)constructor.newInstance(this);
                helper.execute(recipient, args);
            }
            catch (NoSuchMethodException e) {
                System.out.println("cannot find constructor " + this.helperImplementationClass.getCanonicalName() + "(Rule) for helper class");
                e.printStackTrace(System.out);
                return;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                System.out.println("cannot create instance of " + this.helperImplementationClass.getCanonicalName());
                e.printStackTrace(System.out);
                return;
            }
            catch (IllegalAccessException e) {
                System.out.println("cannot access " + this.helperImplementationClass.getCanonicalName());
                e.printStackTrace(System.out);
                return;
            }
            catch (ClassCastException e) {
                System.out.println("cast exception " + this.helperImplementationClass.getCanonicalName());
                e.printStackTrace(System.out);
                return;
            }
            catch (EarlyReturnException e) {
                throw e;
            }
            catch (ThrowException e) {
                throw e;
            }
            catch (ExecuteException e) {
                System.out.println(this.getName() + " : " + e);
                throw e;
            }
            catch (Throwable throwable) {
                System.out.println(this.getName() + " : " + throwable);
                throw new ExecuteException(this.getName() + "  : caught " + throwable, throwable);
            }
        }
    }

    public String getKey() {
        String key;
        if (this.key != null) {
            return this.key;
        }
        this.key = key = this.getName() + "_" + Rule.nextId();
        ruleKeyMap.put(key, this);
        return key;
    }

    public String lookupKey() {
        return this.key;
    }

    public void purge() {
        if (this.key != null) {
            ruleKeyMap.remove(this.key);
            if (this.checked) {
                this.uninstalled();
            }
        }
    }

    private static synchronized int nextId() {
        return nextId++;
    }

    private static boolean compileRules() {
        return Transformer.isCompileToBytecode();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("RULE ");
        stringWriter.write(this.getName());
        stringWriter.write("\n");
        if (this.isInterface()) {
            stringWriter.write("INTERFACE ");
        } else {
            stringWriter.write("CLASS ");
        }
        if (this.isOverride()) {
            stringWriter.write("^");
        }
        stringWriter.write(this.getTargetClass());
        stringWriter.write(10);
        stringWriter.write("METHOD ");
        stringWriter.write(this.getTargetMethod());
        stringWriter.write(10);
        stringWriter.write(this.getTargetLocation().toString());
        stringWriter.write(10);
        if (this.event != null) {
            this.event.writeTo(stringWriter);
        } else {
            stringWriter.write("BIND NOTHING\n");
        }
        if (this.condition != null) {
            this.condition.writeTo(stringWriter);
        } else {
            stringWriter.write("COND   TRUE\n");
        }
        if (this.action != null) {
            this.action.writeTo(stringWriter);
        } else {
            stringWriter.write("DO   NOTHING\n");
        }
        return stringWriter.toString();
    }

    public Class getHelperClass() {
        return this.helperClass;
    }

    private void installed() {
        this.helperManager.installed(this);
    }

    private void uninstalled() {
        this.helperManager.uninstalled(this);
    }

    public int addAccessibleField(Field field) {
        if (this.accessibleFields == null) {
            this.accessibleFields = new ArrayList<Field>();
        }
        int index = this.accessibleFields.size();
        this.accessibleFields.add(field);
        return index;
    }

    public int addAccessibleMethod(Method method) {
        if (this.accessibleMethods == null) {
            this.accessibleMethods = new ArrayList<Method>();
        }
        int index = this.accessibleMethods.size();
        this.accessibleMethods.add(method);
        return index;
    }

    public Object getAccessibleField(Object owner, int fieldIndex) throws ExecuteException {
        try {
            Field field = this.accessibleFields.get(fieldIndex);
            return field.get(owner);
        }
        catch (Exception e) {
            throw new ExecuteException("Rule.getAccessibleField : unexpected error getting non-public field in rule " + this.getName(), e);
        }
    }

    public void setAccessibleField(Object owner, Object value, int fieldIndex) throws ExecuteException {
        try {
            Field field = this.accessibleFields.get(fieldIndex);
            field.set(owner, value);
        }
        catch (Exception e) {
            throw new ExecuteException("Rule.setAccessibleField : unexpected error setting non-public field in rule " + this.getName(), e);
        }
    }

    public Object invokeAccessibleMethod(Object target, Object[] args, int methodIndex) {
        try {
            Method method = this.accessibleMethods.get(methodIndex);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new ExecuteException("Rule.invokeAccessibleMethod : unexpected error invoking non-public method in rule " + this.getName(), e);
        }
    }

    public long getObjectSize(Object o) {
        return this.helperManager.getObjectSize(o);
    }
}

