/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.EvaluationListener;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.internal.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonReader
implements ParseContext,
DocumentContext {
    private static final Logger logger = LoggerFactory.getLogger(JsonReader.class);
    private final Configuration configuration;
    private Object json;
    private Object patch;

    public JsonReader() {
        this(Configuration.defaultConfiguration());
    }

    public JsonReader(Configuration configuration) {
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        this.configuration = configuration;
    }

    private JsonReader(Object json, Configuration configuration) {
        Utils.notNull(json, "json can not be null", new Object[0]);
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        this.configuration = configuration;
        this.json = json;
    }

    @Override
    public DocumentContext parse(Object json) {
        Utils.notNull(json, "json object can not be null", new Object[0]);
        this.json = json;
        return this;
    }

    @Override
    public DocumentContext parse(String json) {
        Utils.notEmpty(json, "json string can not be null or empty", new Object[0]);
        this.json = this.configuration.jsonProvider().parse(json);
        return this;
    }

    @Override
    public DocumentContext parse(InputStream json) {
        return this.parse(json, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContext parse(InputStream json, String charset) {
        Utils.notNull(json, "json input stream can not be null", new Object[0]);
        Utils.notNull(json, "charset can not be null", new Object[0]);
        try {
            this.json = this.configuration.jsonProvider().parse(json, charset);
            JsonReader jsonReader = this;
            return jsonReader;
        }
        finally {
            Utils.closeQuietly(json);
        }
    }

    @Override
    public DocumentContext parse(File json) throws IOException {
        Utils.notNull(json, "json file can not be null", new Object[0]);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(json);
            this.parse(fis);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return this;
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    public Object json() {
        return this.json;
    }

    @Override
    public String jsonString() {
        return this.configuration.jsonProvider().toJson(this.json);
    }

    @Override
    public <T> T read(String path, Predicate ... filters) {
        Utils.notEmpty(path, "path can not be null or empty", new Object[0]);
        return this.read(JsonPath.compile(path, filters));
    }

    @Override
    public <T> T read(String path, Class<T> type, Predicate ... filters) {
        return this.convert(this.read(path, filters), type, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path) {
        Utils.notNull(path, "path can not be null", new Object[0]);
        return path.read(this.json, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path, Class<T> type) {
        return this.convert(this.read(path), type, this.configuration);
    }

    @Override
    public <T> T read(JsonPath path, TypeRef<T> type) {
        return this.convert(this.read(path), type, this.configuration);
    }

    @Override
    public <T> T read(String path, TypeRef<T> type) {
        return this.convert(this.read(path, new Predicate[0]), type, this.configuration);
    }

    @Override
    public ReadContext limit(int maxResults) {
        return this.withListeners(new LimitingEvaluationListener(maxResults));
    }

    @Override
    public ReadContext withListeners(EvaluationListener ... listener) {
        return new JsonReader(this.json, this.configuration.setEvaluationListeners(listener));
    }

    private <T> T convert(Object obj, Class<T> targetType, Configuration configuration) {
        return configuration.mappingProvider().map(obj, targetType, configuration);
    }

    private <T> T convert(Object obj, TypeRef<T> targetType, Configuration configuration) {
        return configuration.mappingProvider().map(obj, targetType, configuration);
    }

    @Override
    public DocumentContext set(String path, Object newValue, Predicate ... filters) {
        return this.set(JsonPath.compile(path, filters), newValue);
    }

    @Override
    public DocumentContext set(JsonPath path, Object newValue) {
        List modified = (List)path.set(this.json, newValue, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Set path {} new value {}", (Object)p, newValue);
            }
        }
        return this;
    }

    @Override
    public DocumentContext delete(String path, Predicate ... filters) {
        return this.delete(JsonPath.compile(path, filters));
    }

    @Override
    public DocumentContext delete(JsonPath path) {
        List modified = (List)path.delete(this.json, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Delete path {}");
            }
        }
        return this;
    }

    @Override
    public DocumentContext add(String path, Object value, Predicate ... filters) {
        return this.add(JsonPath.compile(path, filters), value);
    }

    @Override
    public DocumentContext add(JsonPath path, Object value) {
        List modified = (List)path.add(this.json, value, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Add path {} new value {}", (Object)p, value);
            }
        }
        return this;
    }

    @Override
    public DocumentContext put(String path, String key, Object value, Predicate ... filters) {
        return this.put(JsonPath.compile(path, filters), key, value);
    }

    @Override
    public DocumentContext put(JsonPath path, String key, Object value) {
        List modified = (List)path.put(this.json, key, value, this.configuration.addOptions(Option.AS_PATH_LIST));
        if (logger.isDebugEnabled()) {
            for (String p : modified) {
                logger.debug("Put path {} key {} value {}", p, key, value);
            }
        }
        return this;
    }

    private final class LimitingEvaluationListener
    implements EvaluationListener {
        final int limit;

        private LimitingEvaluationListener(int limit) {
            this.limit = limit;
        }

        @Override
        public EvaluationListener.EvaluationContinuation resultFound(EvaluationListener.FoundResult found) {
            if (found.index() == this.limit - 1) {
                return EvaluationListener.EvaluationContinuation.ABORT;
            }
            return EvaluationListener.EvaluationContinuation.CONTINUE;
        }
    }
}

