/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.token;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.EvaluationListener;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.internal.EvaluationAbortException;
import com.jayway.jsonpath.internal.EvaluationContext;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.Utils;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationContextImpl
implements EvaluationContext {
    private static final Logger logger = LoggerFactory.getLogger(EvaluationContextImpl.class);
    private final Configuration configuration;
    private final Object valueResult;
    private final Object pathResult;
    private final Path path;
    private final Object rootDocument;
    private final List<PathRef> updateOperations;
    private final HashMap<Path, Object> documentEvalCache = new HashMap();
    private final boolean forUpdate;
    private int resultIndex = 0;

    public EvaluationContextImpl(Path path, Object rootDocument, Configuration configuration, boolean forUpdate) {
        Utils.notNull(path, "path can not be null", new Object[0]);
        Utils.notNull(rootDocument, "root can not be null", new Object[0]);
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        this.forUpdate = forUpdate;
        this.path = path;
        this.rootDocument = rootDocument;
        this.configuration = configuration;
        this.valueResult = configuration.jsonProvider().createArray();
        this.pathResult = configuration.jsonProvider().createArray();
        this.updateOperations = new ArrayList<PathRef>();
    }

    public HashMap<Path, Object> documentEvalCache() {
        return this.documentEvalCache;
    }

    public boolean forUpdate() {
        return this.forUpdate;
    }

    public void addResult(String path, PathRef operation, Object model) {
        if (this.forUpdate) {
            this.updateOperations.add(operation);
        }
        this.configuration.jsonProvider().setProperty(this.valueResult, this.resultIndex, model);
        this.configuration.jsonProvider().setProperty(this.pathResult, this.resultIndex, path);
        ++this.resultIndex;
        if (!this.configuration().getEvaluationListeners().isEmpty()) {
            int idx = this.resultIndex - 1;
            for (EvaluationListener listener : this.configuration().getEvaluationListeners()) {
                EvaluationListener.EvaluationContinuation continuation = listener.resultFound(new FoundResultImpl(idx, path, model));
                if (EvaluationListener.EvaluationContinuation.ABORT != continuation) continue;
                throw new EvaluationAbortException();
            }
        }
    }

    public JsonProvider jsonProvider() {
        return this.configuration.jsonProvider();
    }

    public Set<Option> options() {
        return this.configuration.getOptions();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public Object rootDocument() {
        return this.rootDocument;
    }

    @Override
    public Collection<PathRef> updateOperations() {
        Collections.sort(this.updateOperations);
        return Collections.unmodifiableCollection(this.updateOperations);
    }

    @Override
    public <T> T getValue() {
        return this.getValue(true);
    }

    @Override
    public <T> T getValue(boolean unwrap) {
        if (this.path.isDefinite()) {
            if (this.resultIndex == 0) {
                throw new PathNotFoundException("No results for path: " + this.path.toString());
            }
            Object value = this.jsonProvider().getArrayIndex(this.valueResult, 0);
            if (value != null && unwrap) {
                value = this.jsonProvider().unwrap(value);
            }
            return (T)value;
        }
        return (T)this.valueResult;
    }

    @Override
    public <T> T getPath() {
        if (this.resultIndex == 0) {
            throw new PathNotFoundException("No results for path: " + this.path.toString());
        }
        return (T)this.pathResult;
    }

    @Override
    public List<String> getPathList() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.resultIndex > 0) {
            Iterable<?> objects = this.configuration.jsonProvider().toIterable(this.pathResult);
            for (Object o : objects) {
                res.add((String)o);
            }
        }
        return res;
    }

    private class FoundResultImpl
    implements EvaluationListener.FoundResult {
        private final int index;
        private final String path;
        private final Object result;

        private FoundResultImpl(int index, String path, Object result) {
            this.index = index;
            this.path = path;
            this.result = result;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public Object result() {
            return this.result;
        }
    }
}

