/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.collector.internal.actions;

import java.util.HashMap;
import java.util.Map;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.config.Direction;
import org.hawkular.btm.api.model.config.btxn.ProcessorAction;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public abstract class ProcessorActionHandler {
    private static final Logger log = Logger.getLogger(ProcessorActionHandler.class.getName());
    private ProcessorAction action;
    private Object compiledPredicate = null;
    private boolean usesHeaders = false;
    private boolean usesContent = false;

    public ProcessorActionHandler(ProcessorAction action) {
        this.setAction(action);
    }

    public ProcessorAction getAction() {
        return this.action;
    }

    protected void setAction(ProcessorAction action) {
        this.action = action;
    }

    public boolean isUsesHeaders() {
        return this.usesHeaders;
    }

    public void setUsesHeaders(boolean usesHeaders) {
        this.usesHeaders = usesHeaders;
    }

    public boolean isUsesContent() {
        return this.usesContent;
    }

    public void setUsesContent(boolean usesContent) {
        this.usesContent = usesContent;
    }

    public void init() {
        if (this.action.getPredicate() != null) {
            try {
                ParserContext ctx = new ParserContext();
                ctx.addPackageImport("org.hawkular.btm.client.collector.internal.helpers");
                String text = this.action.getPredicate().predicateText();
                this.compiledPredicate = MVEL.compileExpression(text, ctx);
                if (this.compiledPredicate == null) {
                    log.severe("Failed to compile action predicate '" + text + "'");
                } else if (log.isLoggable(Logger.Level.FINE)) {
                    log.fine("Initialised processor action predicate '" + text + "' = " + this.compiledPredicate);
                }
                this.setUsesHeaders(text.indexOf("headers.") != -1);
                this.setUsesContent(text.indexOf("values[") != -1);
            }
            catch (Throwable t) {
                log.log(Logger.Level.SEVERE, "Failed to compile predicate for action '" + this.action + "'", t);
            }
        }
    }

    public boolean process(BusinessTransaction btxn, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.compiledPredicate != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("btxn", btxn);
            vars.put("node", node);
            vars.put("headers", headers);
            vars.put("values", values);
            return (Boolean)MVEL.executeExpression(this.compiledPredicate, vars);
        }
        return true;
    }
}

