/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.check;

import org.jboss.byteman.agent.check.ClassChecker;
import org.jboss.byteman.agent.check.ClassStructureAdapter;
import org.jboss.byteman.objectweb.asm.ClassReader;
import org.jboss.byteman.rule.type.TypeHelper;

public class BytecodeChecker
implements ClassChecker {
    ClassStructureAdapter adapter;

    public BytecodeChecker(byte[] buffer) {
        ClassReader cr = new ClassReader(buffer);
        this.adapter = new ClassStructureAdapter();
        cr.accept(this.adapter, 7);
    }

    @Override
    public boolean isInterface() {
        return this.adapter.isInterface();
    }

    @Override
    public String getSuper() {
        String supername = this.adapter.getSuper();
        if (supername != null) {
            supername = TypeHelper.internalizeClass(this.adapter.getSuper());
        }
        return supername;
    }

    @Override
    public boolean hasOuterClass() {
        return this.adapter.getOuterClass() != null;
    }

    @Override
    public int getInterfaceCount() {
        return this.adapter.getInterfaces().length;
    }

    @Override
    public String getInterface(int idx) {
        return TypeHelper.internalizeClass(this.adapter.getInterfaces()[idx]);
    }
}

