/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.completiontime;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.server.api.task.Processor;

public class CompletionTimeDeriver
implements Processor<BusinessTransaction, CompletionTime> {
    private static final Logger log = Logger.getLogger(CompletionTimeDeriver.class.getName());

    public boolean isMultiple() {
        return false;
    }

    public CompletionTime processSingle(BusinessTransaction item) throws Exception {
        if (item.getName() != null && item.getName().trim().length() > 0 && !item.getNodes().isEmpty()) {
            Node n = (Node)item.getNodes().get(0);
            boolean interaction = false;
            for (int i = 0; !interaction && i < n.getCorrelationIds().size(); ++i) {
                interaction = ((CorrelationIdentifier)n.getCorrelationIds().get(i)).getScope() == CorrelationIdentifier.Scope.Interaction;
            }
            if (!interaction) {
                CompletionTime ct = new CompletionTime();
                ct.setId(item.getId());
                ct.setBusinessTransaction(item.getName());
                ct.setDuration(n.getDuration());
                ct.setFault(n.getFault());
                ct.setProperties(item.getProperties());
                ct.setTimestamp(item.getStartTime());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("CompletionTimeDeriver ret=" + ct);
                }
                return ct;
            }
        }
        return null;
    }

    public List<CompletionTime> processMultiple(BusinessTransaction item) throws Exception {
        return null;
    }
}

