/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.fragmentcompletiontime;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.server.api.task.AbstractProcessor;

public class FragmentCompletionTimeDeriver
extends AbstractProcessor<BusinessTransaction, CompletionTime> {
    private static final Logger log = Logger.getLogger(FragmentCompletionTimeDeriver.class.getName());

    public boolean isMultiple() {
        return false;
    }

    public CompletionTime processSingle(String tenantId, BusinessTransaction item) throws Exception {
        if (!item.getNodes().isEmpty()) {
            Node n = (Node)item.getNodes().get(0);
            CompletionTime ct = new CompletionTime();
            ct.setId(item.getId());
            ct.setUri(n.getUri());
            ct.setBusinessTransaction(item.getName());
            ct.setDuration(item.calculateDuration());
            ct.setFault(n.getFault());
            ct.setProperties(item.getProperties());
            ct.setTimestamp(item.getStartTime());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("FragmentCompletionTimeDeriver ret=" + ct);
            }
            return ct;
        }
        return null;
    }

    public List<CompletionTime> processMultiple(String tenantId, BusinessTransaction item) throws Exception {
        return null;
    }
}

