/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.fragmentcompletiontime;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.api.model.trace.Consumer;
import org.hawkular.btm.api.model.trace.Node;
import org.hawkular.btm.api.model.trace.Trace;
import org.hawkular.btm.server.api.task.AbstractProcessor;

public class FragmentCompletionTimeDeriver
extends AbstractProcessor<Trace, CompletionTime> {
    private static final Logger log = Logger.getLogger(FragmentCompletionTimeDeriver.class.getName());

    public boolean isMultiple() {
        return false;
    }

    public CompletionTime processSingle(String tenantId, Trace item) throws Exception {
        if (!item.getNodes().isEmpty()) {
            Node n = (Node)item.getNodes().get(0);
            CompletionTime ct = new CompletionTime();
            ct.setId(item.getId());
            ct.setUri(n.getUri());
            ct.setOperation(n.getOperation());
            if (n.getClass() == Consumer.class) {
                ct.setEndpointType(((Consumer)n).getEndpointType());
                ct.setInternal(((Consumer)n).getEndpointType() == null || ((Consumer)n).getEndpointType().trim().length() == 0);
            }
            ct.setBusinessTransaction(item.getBusinessTransaction());
            ct.setDuration(item.calculateDuration());
            ct.setPrincipal(item.getPrincipal());
            ct.setFault(n.getFault());
            ct.setHostName(item.getHostName());
            ct.setProperties(item.getProperties());
            ct.setTimestamp(item.getStartTime());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("FragmentCompletionTimeDeriver ret=" + ct);
            }
            return ct;
        }
        return null;
    }

    public List<CompletionTime> processMultiple(String tenantId, Trace item) throws Exception {
        return null;
    }
}

