/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.notification;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.events.Notification;
import org.hawkular.btm.server.api.task.Processor;

public class NotificationDeriver
implements Processor<BusinessTransaction, Notification> {
    private static final Logger log = Logger.getLogger(NotificationDeriver.class.getName());

    public boolean isMultiple() {
        return false;
    }

    public Notification processSingle(BusinessTransaction item) throws Exception {
        if (item.getName() != null && item.getName().trim().length() > 0 && !item.getNodes().isEmpty()) {
            Notification notification = new Notification();
            notification.setId(item.getId());
            notification.setBusinessTransaction(item.getName());
            notification.setTimestamp(item.getStartTime());
            notification.setHostAddress(item.getHostAddress());
            notification.setHostName(item.getHostName());
            this.findIssues(item.getNodes(), notification);
            if (!notification.getIssues().isEmpty()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("NotificationDeriver ret=" + notification);
                }
                return notification;
            }
        }
        return null;
    }

    protected void findIssues(List<Node> nodes, Notification notification) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!node.getIssues().isEmpty()) {
                notification.getIssues().addAll(node.getIssues());
            }
            if (!node.containerNode()) continue;
            this.findIssues(((ContainerNode)node).getNodes(), notification);
        }
    }

    public List<Notification> processMultiple(BusinessTransaction item) throws Exception {
        return null;
    }
}

