/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.processor.notification;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.events.Notification;
import org.hawkular.btm.api.model.trace.ContainerNode;
import org.hawkular.btm.api.model.trace.Node;
import org.hawkular.btm.api.model.trace.Trace;
import org.hawkular.btm.server.api.task.AbstractProcessor;

public class NotificationDeriver
extends AbstractProcessor<Trace, Notification> {
    private static final Logger log = Logger.getLogger(NotificationDeriver.class.getName());

    public boolean isMultiple() {
        return false;
    }

    public Notification processSingle(String tenantId, Trace item) throws Exception {
        if (item.getBusinessTransaction() != null && item.getBusinessTransaction().trim().length() > 0 && !item.getNodes().isEmpty()) {
            Notification notification = new Notification();
            notification.setId(item.getId());
            notification.setBusinessTransaction(item.getBusinessTransaction());
            notification.setTimestamp(item.getStartTime());
            notification.setHostAddress(item.getHostAddress());
            notification.setHostName(item.getHostName());
            notification.setPrincipal(item.getPrincipal());
            this.findIssues(item.getNodes(), notification);
            if (!notification.getIssues().isEmpty()) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("NotificationDeriver ret=" + notification);
                }
                return notification;
            }
        }
        return null;
    }

    protected void findIssues(List<Node> nodes, Notification notification) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!node.getIssues().isEmpty()) {
                notification.getIssues().addAll(node.getIssues());
            }
            if (!node.containerNode()) continue;
            this.findIssues(((ContainerNode)node).getNodes(), notification);
        }
    }

    public List<Notification> processMultiple(String tenantId, Trace item) throws Exception {
        return null;
    }
}

