/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.api.task;

import java.util.ArrayList;
import java.util.List;
import org.hawkular.btm.server.api.log.MsgLogger;
import org.hawkular.btm.server.api.task.Handler;
import org.hawkular.btm.server.api.task.Processor;

public class ProcessingUnit<T, R>
implements Handler<T> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private Processor<T, R> processor;
    private int retryCount;
    private Handler<R> resultHandler;
    private Handler<T> retryHandler;

    public Processor<T, R> getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor<T, R> processor) {
        this.processor = processor;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public Handler<R> getResultHandler() {
        return this.resultHandler;
    }

    public void setResultHandler(Handler<R> resultHandler) {
        this.resultHandler = resultHandler;
    }

    public Handler<T> getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(Handler<T> retryHandler) {
        this.retryHandler = retryHandler;
    }

    @Override
    public void handle(String tenantId, List<T> items) throws Exception {
        ArrayList<Object> results = null;
        ArrayList<T> retries = null;
        Exception lastException = null;
        this.processor.initialise(tenantId, items);
        for (int i = 0; i < items.size(); ++i) {
            try {
                List<R> result;
                if (this.processor.isMultiple()) {
                    result = this.processor.processMultiple(tenantId, items.get(i));
                    if (this.resultHandler == null || result == null || result.size() <= 0) continue;
                    if (results == null) {
                        results = new ArrayList();
                    }
                    results.addAll(result);
                    continue;
                }
                result = this.processor.processSingle(tenantId, items.get(i));
                if (this.resultHandler == null || result == null) continue;
                if (results == null) {
                    results = new ArrayList<Object>();
                }
                results.add(result);
                continue;
            }
            catch (Exception e) {
                if (this.retryHandler == null) continue;
                if (retries == null) {
                    retries = new ArrayList<T>();
                }
                retries.add(items.get(i));
                lastException = e;
            }
        }
        this.processor.cleanup(tenantId, items);
        if (results != null && results.size() > 0) {
            this.resultHandler.handle(tenantId, results);
        }
        if (retries != null && retries.size() > 0) {
            if (this.getRetryCount() > 0) {
                this.retryHandler.handle(tenantId, retries);
            } else {
                this.msgLog.warnMaxRetryReached(lastException);
            }
        }
    }
}

