/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;

@Singleton
public class CassandraClient {
    private static final Logger log = Logger.getLogger(CassandraClient.class.getName());
    private Session session;

    @PostConstruct
    public void init() {
    }

    public synchronized Session getSession() {
        if (this.session == null) {
            try {
                this.session = new Cluster.Builder().addContactPoints(new String[]{"127.0.0.1"}).withPort(new Integer("9042").intValue()).withProtocolVersion(ProtocolVersion.V3).withoutJMXReporting().build().connect();
                this.configureSchema();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            log.fine("Initialised cassandra session=" + this.session);
        }
        return this.session;
    }

    protected void configureSchema() {
        try {
            InputStream input = this.getClass().getResourceAsStream("/hawkular_btm.cql");
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                for (String cql : content.split("(?m)^-- #.*$")) {
                    if (cql.startsWith("--")) continue;
                    this.session.execute(cql);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Executed CQL = " + cql);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not get the initialized session.");
        }
    }

    @PreDestroy
    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }
}

