/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.api.services.Criteria;
import org.hawkular.btm.server.cassandra.CassandraClient;
import org.hawkular.btm.server.cassandra.CassandraServiceUtil;
import org.hawkular.btm.server.cassandra.log.MsgLogger;

@Singleton
public class BusinessTransactionServiceCassandra
implements BusinessTransactionService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final Logger log = Logger.getLogger(BusinessTransactionServiceCassandra.class.getName());
    private static ObjectMapper mapper = new ObjectMapper();
    private PreparedStatement getBusinessTransaction;
    private PreparedStatement insertBusinessTransaction;
    private PreparedStatement deleteBusinessTransactions;
    @Inject
    private CassandraClient client;

    public CassandraClient getClient() {
        return this.client;
    }

    public void setClient(CassandraClient client) {
        this.client = client;
    }

    @PostConstruct
    public void init() {
        this.getBusinessTransaction = this.getClient().getSession().prepare("SELECT doc FROM hawkular_btm.businesstransactions WHERE tenantId = ? AND id = ?;");
        this.insertBusinessTransaction = this.getClient().getSession().prepare("INSERT INTO hawkular_btm.businesstransactions (tenantId, datetime, id, businessTransaction, hostName, properties, correlationIds, doc) VALUES (?, ?, ?, ?, ?, ?, ?, ?);");
        this.deleteBusinessTransactions = this.getClient().getSession().prepare("DELETE FROM hawkular_btm.businesstransactions WHERE tenantId = ?;");
    }

    public BusinessTransaction get(String tenantId, String id) {
        ResultSet results = this.getClient().getSession().execute((Statement)new BoundStatement(this.getBusinessTransaction).bind(new Object[]{tenantId, id}));
        Row row = results.one();
        if (row != null) {
            try {
                return (BusinessTransaction)mapper.readValue(row.getString("doc"), BusinessTransaction.class);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        return null;
    }

    public List<BusinessTransaction> query(String tenantId, Criteria criteria) {
        ArrayList<BusinessTransaction> ret = new ArrayList<BusinessTransaction>();
        StringBuilder statement = new StringBuilder("SELECT doc FROM hawkular_btm.businesstransactions");
        statement.append(CassandraServiceUtil.whereClause(tenantId, criteria));
        statement.append(" ALLOW FILTERING;");
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Query statement = " + statement.toString());
        }
        ResultSet results = this.getClient().getSession().execute(statement.toString());
        for (Row row : results) {
            try {
                BusinessTransaction btxn = (BusinessTransaction)mapper.readValue(row.getString("doc"), BusinessTransaction.class);
                if (CassandraServiceUtil.exclude(btxn.getProperties(), null, criteria)) continue;
                ret.add(btxn);
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        return ret;
    }

    public void storeBusinessTransactions(String tenantId, List<BusinessTransaction> businessTransactions) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Store business transactions (tenantId=" + tenantId + "):" + businessTransactions);
        }
        BatchStatement batch = new BatchStatement();
        for (int i = 0; i < businessTransactions.size(); ++i) {
            BusinessTransaction btxn = businessTransactions.get(i);
            List cids = null;
            if (!btxn.getNodes().isEmpty()) {
                cids = ((Node)btxn.getNodes().get(0)).getCorrelationIds();
            }
            batch.add((Statement)new BoundStatement(this.insertBusinessTransaction).bind(new Object[]{CassandraServiceUtil.tenant(tenantId), new Date(btxn.getStartTime()), btxn.getId(), CassandraServiceUtil.emptyStringForNull(btxn.getName()), btxn.getHostName(), CassandraServiceUtil.toTagList(btxn.getProperties()), CassandraServiceUtil.toTagList(cids), mapper.writeValueAsString((Object)btxn)}));
        }
        this.getClient().getSession().execute((Statement)batch);
    }

    public void clear(String tenantId) {
        this.client.getSession().execute((Statement)new BoundStatement(this.deleteBusinessTransactions).bind(new Object[]{CassandraServiceUtil.tenant(tenantId)}));
    }
}

