/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch.proxy;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.hawkular.btm.server.elasticsearch.proxy.ElasticsearchHttpClient;

public class ElasticsearchRESTServer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log;
    private ElasticsearchHttpClient client = new ElasticsearchHttpClient();
    private static final HeaderGroup HOPBYHOPHEADERS;

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Elasticsearch Proxy: Request method=" + servletRequest.getMethod() + " path=" + servletRequest.getPathInfo());
        }
        if (this.isSupported(servletRequest)) {
            try {
                HttpResponse resp = this.client.process(servletRequest);
                servletResponse.setStatus(resp.getStatusLine().getStatusCode());
                this.copyResponseHeaders(resp, servletResponse);
                this.copyResponseContent(resp, servletResponse);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Elasticsearch Proxy: Response status code=" + servletResponse.getStatus());
                }
            }
            catch (ConnectException ce) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Elasticsearch Proxy: connection failure", ce);
                }
                servletResponse.setStatus(503);
            }
            catch (IOException ioe) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Elasticsearch Proxy: I/O failure", ioe);
                }
                servletResponse.sendError(500, ioe.getMessage());
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Elasticsearch Proxy: general failure", e);
                }
                servletResponse.sendError(500, e.getMessage());
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Elasticsearch Proxy: Forbidden request method=" + servletRequest.getMethod() + " path=" + servletRequest.getPathInfo());
            }
            servletResponse.setStatus(403);
        }
    }

    protected boolean isSupported(HttpServletRequest servletRequest) {
        if (servletRequest.getMethod().equalsIgnoreCase("get")) {
            return true;
        }
        return servletRequest.getMethod().equalsIgnoreCase("post") ? servletRequest.getPathInfo().endsWith("/_search") : servletRequest.getMethod().equalsIgnoreCase("put") && servletRequest.getPathInfo().startsWith("/kibana-int/dashboard");
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (int i = 0; i < proxyResponse.getAllHeaders().length; ++i) {
            Header header = proxyResponse.getAllHeaders()[i];
            if (HOPBYHOPHEADERS.containsHeader(header.getName())) continue;
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResponseContent(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
        try {
            proxyResponse.getEntity().writeTo((OutputStream)servletOutputStream);
        }
        finally {
            try {
                servletOutputStream.close();
            }
            catch (Exception e) {
                this.log(e.getMessage(), e);
            }
        }
    }

    static {
        String[] headers;
        log = Logger.getLogger(ElasticsearchRESTServer.class.getName());
        HOPBYHOPHEADERS = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            HOPBYHOPHEADERS.addHeader((Header)new BasicHeader(header, null));
        }
    }
}

