/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch.proxy;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class ElasticsearchHttpClient {
    private static final String DEFAULT_ELASTIC_SEARCH_URL = "http://localhost:9200";
    private static final Logger LOG;
    private HttpClient proxyClient;
    private String url;
    private static final HeaderGroup HOPBYHOPHEADERS;

    public ElasticsearchHttpClient() {
        BasicHttpParams hcParams = new BasicHttpParams();
        this.proxyClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager(), (HttpParams)hcParams);
        this.url = System.getProperty("elasticsearch.server", DEFAULT_ELASTIC_SEARCH_URL);
    }

    public HttpResponse process(HttpServletRequest request) throws Exception {
        BasicHttpRequest proxyRequest;
        String proxyRequestUri = this.rewriteUrlFromRequest(request);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Rewritten URL: " + proxyRequestUri);
        }
        if (request.getHeader("Content-Length") != null || request.getHeader("Transfer-Encoding") != null) {
            byte[] b;
            int len;
            BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(request.getMethod(), proxyRequestUri);
            ServletInputStream is = request.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = is.read(b = new byte[10240])) != -1) {
                baos.write(b, 0, len);
            }
            is.close();
            baos.close();
            ByteArrayEntity entity = new ByteArrayEntity(baos.toByteArray());
            is.close();
            eProxyRequest.setEntity((HttpEntity)entity);
            proxyRequest = eProxyRequest;
        } else {
            proxyRequest = new BasicHttpRequest(request.getMethod(), proxyRequestUri);
        }
        this.copyRequestHeaders(request, (HttpRequest)proxyRequest, proxyRequestUri);
        try {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("proxy " + request.getMethod() + " uri: " + request.getRequestURI() + " -- " + proxyRequest.getRequestLine().getUri());
            }
            return this.proxyClient.execute(URIUtils.extractHost((URI)new URI(proxyRequestUri)), (HttpRequest)proxyRequest);
        }
        catch (Exception e) {
            if (proxyRequest instanceof AbortableHttpRequest) {
                AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)proxyRequest;
                abortableHttpRequest.abort();
            }
            throw e;
        }
    }

    public void close() {
        if (this.proxyClient != null) {
            this.proxyClient.getConnectionManager().shutdown();
        }
    }

    protected void copyRequestHeaders(HttpServletRequest request, HttpRequest proxyRequest, String uri) throws Exception {
        Enumeration iter = request.getHeaderNames();
        while (iter.hasMoreElements()) {
            String key = (String)iter.nextElement();
            if (key.equalsIgnoreCase("Content-Length") || HOPBYHOPHEADERS.containsHeader(key)) continue;
            String headerValue = request.getHeader(key);
            if (key.equalsIgnoreCase("Host")) {
                HttpHost host = URIUtils.extractHost((URI)new URI(uri));
                headerValue = host.getHostName();
                if (host.getPort() != -1) {
                    headerValue = headerValue + ":" + host.getPort();
                }
            }
            proxyRequest.addHeader(key, headerValue);
        }
    }

    protected String rewriteUrlFromRequest(HttpServletRequest request) {
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.url);
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            if (pathInfo.startsWith("/kibana-int/dashboard/")) {
                pathInfo = pathInfo.replaceFirst("dashboard", "dashboard-" + request.getUserPrincipal().getName());
            } else if (pathInfo.contains("/btm/") && request.getRemoteUser() != null) {
                pathInfo = pathInfo.replaceFirst("/btm/", "/btm-" + request.getRemoteUser() + "/");
            }
            uri.append(pathInfo);
        }
        Enumeration iter = request.getParameterNames();
        boolean f_first = true;
        if (iter.hasMoreElements()) {
            uri.append('?');
        }
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            String[] values = request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                if (!f_first) {
                    uri.append('&');
                }
                uri.append(name);
                uri.append('=');
                uri.append(values[i]);
                f_first = false;
            }
        }
        String ret = uri.toString();
        ret = ret.replaceAll(" ", "%20");
        return ret;
    }

    static {
        String[] headers;
        LOG = Logger.getLogger(ElasticsearchHttpClient.class.getName());
        HOPBYHOPHEADERS = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            HOPBYHOPHEADERS.addHeader((Header)new BasicHeader(header, null));
        }
    }
}

