/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesBuilder;
import org.hawkular.btm.api.model.analytics.CompletionTime;
import org.hawkular.btm.api.model.analytics.Percentiles;
import org.hawkular.btm.api.model.analytics.ResponseTime;
import org.hawkular.btm.api.model.analytics.URIInfo;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.services.AnalyticsService;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.server.elasticsearch.BusinessTransactionServiceElasticsearch;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

@Singleton
public class AnalyticsServiceElasticsearch
implements AnalyticsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String RESPONSE_TIME_TYPE = "responsetime";
    private static final String COMPLETION_TIME_TYPE = "completiontime";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ElasticsearchClient client;
    @Inject
    private ConfigurationService configService;

    @PostConstruct
    public void init() {
        this.client = new ElasticsearchClient();
        try {
            this.client.init();
        }
        catch (Exception e) {
            this.msgLog.errorFailedToInitialiseElasticsearchClient(e);
        }
    }

    protected ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    protected void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    public ConfigurationService getConfigurationService() {
        return this.configService;
    }

    public void setConfigurationService(ConfigurationService cs) {
        this.configService = cs;
    }

    public List<URIInfo> getUnboundURIs(String tenantId, long startTime, long endTime) {
        ArrayList<URIInfo> ret = new ArrayList<URIInfo>();
        HashMap<String, URIInfo> map = new HashMap<String, URIInfo>();
        BusinessTransactionCriteria criteria = new BusinessTransactionCriteria().setStartTime(startTime).setEndTime(endTime);
        List<BusinessTransaction> fragments = BusinessTransactionServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            if (!btxn.initialFragment() || btxn.getNodes().isEmpty() || btxn.getName() != null) continue;
            if (btxn.getNodes().get(0) instanceof Consumer) {
                Consumer consumer = (Consumer)btxn.getNodes().get(0);
                String uri = consumer.getUri();
                if (map.containsKey(uri) || consumer.getFault() != null) continue;
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(consumer.getEndpointType());
                ret.add(info);
                map.put(uri, info);
                continue;
            }
            this.obtainProducerURIs(btxn.getNodes(), ret, map);
        }
        if (this.configService != null) {
            Map configs = this.configService.getBusinessTransactions(tenantId, 0L);
            for (BusinessTxnConfig config : configs.values()) {
                if (config.getFilter() == null || config.getFilter().getInclusions() == null) continue;
                if (this.msgLog.isTraceEnabled()) {
                    this.msgLog.trace("Remove unbound URIs associated with btxn config=" + config);
                }
                for (String filter : config.getFilter().getInclusions()) {
                    Iterator iter = ret.iterator();
                    while (iter.hasNext()) {
                        URIInfo info = (URIInfo)iter.next();
                        if (!Pattern.matches(filter, info.getUri())) continue;
                        iter.remove();
                    }
                }
            }
        }
        Collections.sort(ret, new Comparator<URIInfo>(){

            @Override
            public int compare(URIInfo arg0, URIInfo arg1) {
                return arg0.getUri().compareTo(arg1.getUri());
            }
        });
        return ret;
    }

    protected void obtainProducerURIs(List<Node> nodes, List<URIInfo> uris, Map<String, URIInfo> map) {
        for (int i = 0; i < nodes.size(); ++i) {
            String uri;
            Node node = nodes.get(i);
            if (node instanceof Producer && !map.containsKey(uri = node.getUri())) {
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(((Producer)node).getEndpointType());
                uris.add(info);
                map.put(uri, info);
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainProducerURIs(((ContainerNode)node).getNodes(), uris, map);
        }
    }

    public List<String> getBoundURIs(String tenantId, String businessTransaction, long startTime, long endTime) {
        ArrayList<String> ret = new ArrayList<String>();
        BusinessTransactionCriteria criteria = new BusinessTransactionCriteria().setName(businessTransaction).setStartTime(startTime).setEndTime(endTime);
        List<BusinessTransaction> fragments = BusinessTransactionServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            this.obtainURIs(btxn.getNodes(), ret);
        }
        return ret;
    }

    protected void obtainURIs(List<Node> nodes, List<String> uris) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (node.getUri() != null && !uris.contains(node.getUri())) {
                uris.add(node.getUri());
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainURIs(((ContainerNode)node).getNodes(), uris);
        }
    }

    public long getCompletionCount(String tenantId, BusinessTransactionCriteria criteria) {
        SearchRequestBuilder request;
        SearchResponse response;
        if (criteria.getName() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        long startTime = criteria.getStartTime();
        long endTime = criteria.getEndTime();
        if (endTime == 0L) {
            endTime = System.currentTimeMillis();
        }
        if (startTime == 0L) {
            startTime = endTime - 3600000L;
        }
        BoolQueryBuilder b2 = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").from(startTime).to(endTime));
        b2 = b2.must((QueryBuilder)QueryBuilders.termQuery((String)"businessTransaction", (String)criteria.getName()));
        if (!criteria.getProperties().isEmpty()) {
            for (String key : criteria.getProperties().keySet()) {
                b2 = b2.must((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + key), criteria.getProperties().get(key)));
            }
        }
        if ((response = (SearchResponse)(request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)b2)).execute().actionGet()).isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
            return 0L;
        }
        return response.getHits().getTotalHits();
    }

    public long getCompletionFaultCount(String tenantId, BusinessTransactionCriteria criteria) {
        if (criteria.getName() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        long startTime = criteria.getStartTime();
        long endTime = criteria.getEndTime();
        if (endTime == 0L) {
            endTime = System.currentTimeMillis();
        }
        if (startTime == 0L) {
            startTime = endTime - 3600000L;
        }
        BoolQueryBuilder b2 = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").from(startTime).to(endTime));
        b2 = b2.must((QueryBuilder)QueryBuilders.termQuery((String)"businessTransaction", (String)criteria.getName()));
        if (!criteria.getProperties().isEmpty()) {
            for (String key : criteria.getProperties().keySet()) {
                b2 = b2.must((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + key), criteria.getProperties().get(key)));
            }
        }
        ExistsFilterBuilder filter = FilterBuilders.existsFilter((String)"fault");
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)b2).setPostFilter((FilterBuilder)filter);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
            return 0L;
        }
        return response.getHits().getTotalHits();
    }

    public Percentiles getCompletionPercentiles(String tenantId, BusinessTransactionCriteria criteria) {
        if (criteria.getName() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        long startTime = criteria.getStartTime();
        long endTime = criteria.getEndTime();
        if (endTime == 0L) {
            endTime = System.currentTimeMillis();
        }
        if (startTime == 0L) {
            startTime = endTime - 3600000L;
        }
        BoolQueryBuilder b2 = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").from(startTime).to(endTime));
        b2 = b2.must((QueryBuilder)QueryBuilders.termQuery((String)"businessTransaction", (String)criteria.getName()));
        if (!criteria.getProperties().isEmpty()) {
            for (String key : criteria.getProperties().keySet()) {
                b2 = b2.must((QueryBuilder)QueryBuilders.matchQuery((String)("properties." + key), criteria.getProperties().get(key)));
            }
        }
        PercentilesBuilder percentileAgg = (PercentilesBuilder)AggregationBuilders.percentiles((String)"percentiles").field("duration");
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)percentileAgg).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setQuery((QueryBuilder)b2);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        Percentiles percentiles = new Percentiles();
        org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles agg = (org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles)response.getAggregations().get("percentiles");
        for (Percentile entry : agg) {
            percentiles.addPercentile((int)entry.getPercent(), entry.getValue());
        }
        return percentiles;
    }

    public int getAlertCount(String tenantId, String name) {
        return 0;
    }

    public void storeResponseTimes(String tenantId, List<ResponseTime> responseTimes) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < responseTimes.size(); ++i) {
            ResponseTime rt = responseTimes.get(i);
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), RESPONSE_TIME_TYPE, rt.getId()).setSource(mapper.writeValueAsString((Object)rt)));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store response times: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store response times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing response times to elasticsearch");
        }
    }

    public void storeCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < completionTimes.size(); ++i) {
            CompletionTime ct = completionTimes.get(i);
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), COMPLETION_TIME_TYPE, ct.getId()).setSource(mapper.writeValueAsString((Object)ct)));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store completion times: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store completion times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing completion times to elasticsearch");
        }
    }

    protected void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
    }

    @PreDestroy
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

