/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnSummary;
import org.hawkular.btm.api.services.ConfigurationLoader;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

@Singleton
public class ConfigurationServiceElasticsearch
implements ConfigurationService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String BUSINESS_TXN_CONFIG_TYPE = "businesstxnconfig";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ElasticsearchClient client;
    private static int DEFAULT_RESPONSE_SIZE = 100000;
    private static long DEFAULT_TIMEOUT = 10000L;
    private long timeout = DEFAULT_TIMEOUT;
    private int maxResponseSize = DEFAULT_RESPONSE_SIZE;

    @PostConstruct
    public void init() {
        this.client = new ElasticsearchClient();
        try {
            this.client.init();
        }
        catch (Exception e) {
            this.msgLog.errorFailedToInitialiseElasticsearchClient(e);
        }
    }

    public CollectorConfiguration getCollector(String tenantId, String host, String server) {
        CollectorConfiguration config;
        block6: {
            config = ConfigurationLoader.getConfiguration();
            try {
                String index = this.client.getIndex(tenantId);
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        BusinessTxnConfig btc = (BusinessTxnConfig)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTxnConfig.class);
                        if (btc.isDeleted()) continue;
                        config.getBusinessTransactions().put(searchHitFields.getId(), btc);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block6;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction configs", new Object[0]);
            }
        }
        return config;
    }

    public void updateBusinessTransaction(String tenantId, String name, BusinessTxnConfig config) throws Exception {
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Update business transaction config with name[%s] config=%s", name, config);
        }
        config.setLastUpdated(System.currentTimeMillis());
        IndexRequestBuilder builder = this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), BUSINESS_TXN_CONFIG_TYPE, name).setRouting(name).setSource(mapper.writeValueAsString((Object)config));
        builder.execute().actionGet();
    }

    public BusinessTxnConfig getBusinessTransaction(String tenantId, String name) {
        BusinessTxnConfig ret;
        block7: {
            ret = null;
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Get business transaction config with name[%s]", name);
            }
            try {
                String index = this.client.getIndex(tenantId);
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                GetResponse response = (GetResponse)this.client.getElasticsearchClient().prepareGet(index, BUSINESS_TXN_CONFIG_TYPE, name).setRouting(name).execute().actionGet();
                if (response.isSourceEmpty()) break block7;
                try {
                    ret = (BusinessTxnConfig)mapper.readValue(response.getSourceAsString(), BusinessTxnConfig.class);
                    if (ret.isDeleted()) {
                        ret = null;
                    }
                }
                catch (Exception e) {
                    this.msgLog.errorFailedToParse(e);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block7;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction config [%s]", name);
            }
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Get business transaction config with name[%s] is: %s", name, ret);
        }
        return ret;
    }

    public List<BusinessTxnSummary> getBusinessTransactionSummaries(String tenantId) {
        ArrayList<BusinessTxnSummary> ret;
        block6: {
            ret = new ArrayList<BusinessTxnSummary>();
            String index = this.client.getIndex(tenantId);
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        BusinessTxnConfig config = (BusinessTxnConfig)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTxnConfig.class);
                        if (config.isDeleted()) continue;
                        BusinessTxnSummary summary = new BusinessTxnSummary();
                        summary.setName(searchHitFields.getId());
                        summary.setDescription(config.getDescription());
                        summary.setLevel(config.getLevel());
                        ret.add(summary);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block6;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction summaries", new Object[0]);
            }
        }
        return ret;
    }

    public Map<String, BusinessTxnConfig> getBusinessTransactions(String tenantId, long updated) {
        HashMap<String, BusinessTxnConfig> ret;
        block6: {
            ret = new HashMap<String, BusinessTxnConfig>();
            String index = this.client.getIndex(tenantId);
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        BusinessTxnConfig btxn = (BusinessTxnConfig)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTxnConfig.class);
                        if ((updated != 0L || btxn.isDeleted()) && (updated <= 0L || btxn.getLastUpdated() <= updated)) continue;
                        ret.put(searchHitFields.getId(), btxn);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block6;
                this.msgLog.tracef("No index found, so unable to retrieve business transaction names", new Object[0]);
            }
        }
        return ret;
    }

    public void removeBusinessTransaction(String tenantId, String name) throws Exception {
        BusinessTxnConfig config = new BusinessTxnConfig();
        config.setDeleted(true);
        config.setLastUpdated(System.currentTimeMillis());
        IndexRequestBuilder builder = this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), BUSINESS_TXN_CONFIG_TYPE, name).setRouting(name).setSource(mapper.writeValueAsString((Object)config));
        builder.execute().actionGet();
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Remove business transaction config with name[%s]", name);
        }
    }

    protected void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
    }

    @PreDestroy
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

