/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.missing.MissingBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.avg.AvgBuilder;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.Stats;
import org.elasticsearch.search.aggregations.metrics.stats.StatsBuilder;
import org.hawkular.btm.api.model.analytics.Cardinality;
import org.hawkular.btm.api.model.analytics.CompletionTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.NodeSummaryStatistics;
import org.hawkular.btm.api.model.analytics.NodeTimeseriesStatistics;
import org.hawkular.btm.api.model.analytics.Percentiles;
import org.hawkular.btm.api.model.analytics.PropertyInfo;
import org.hawkular.btm.api.model.analytics.URIInfo;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.Consumer;
import org.hawkular.btm.api.model.btxn.ContainerNode;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.model.btxn.Producer;
import org.hawkular.btm.api.model.config.btxn.BusinessTxnConfig;
import org.hawkular.btm.api.model.events.CompletionTime;
import org.hawkular.btm.api.model.events.NodeDetails;
import org.hawkular.btm.api.services.AbstractAnalyticsService;
import org.hawkular.btm.api.services.BaseCriteria;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.CompletionTimeCriteria;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.api.services.NodeCriteria;
import org.hawkular.btm.server.elasticsearch.BusinessTransactionServiceElasticsearch;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.ElasticsearchUtil;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

public class AnalyticsServiceElasticsearch
extends AbstractAnalyticsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String NODE_DETAILS_TYPE = "nodedetails";
    private static final String COMPLETION_TIME_TYPE = "completiontime";
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    private ElasticsearchClient client;
    @Inject
    private ConfigurationService configService;

    protected ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    protected void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    public ConfigurationService getConfigurationService() {
        return this.configService;
    }

    public void setConfigurationService(ConfigurationService cs) {
        this.configService = cs;
    }

    public List<URIInfo> getUnboundURIs(String tenantId, long startTime, long endTime, boolean compress) {
        ArrayList<URIInfo> ret = new ArrayList();
        HashMap<String, URIInfo> map = new HashMap<String, URIInfo>();
        BusinessTransactionCriteria criteria = new BusinessTransactionCriteria();
        criteria.setStartTime(startTime).setEndTime(endTime);
        List<BusinessTransaction> fragments = BusinessTransactionServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            if (!btxn.initialFragment() || btxn.getNodes().isEmpty() || btxn.getName() != null) continue;
            if (btxn.getNodes().get(0) instanceof Consumer) {
                Consumer consumer = (Consumer)btxn.getNodes().get(0);
                String uri = consumer.getUri();
                if (map.containsKey(uri) || consumer.getFault() != null) continue;
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(consumer.getEndpointType());
                ret.add(info);
                map.put(uri, info);
                continue;
            }
            this.obtainProducerURIs(btxn.getNodes(), ret, map);
        }
        if (this.configService != null) {
            Map configs = this.configService.getBusinessTransactions(tenantId, 0L);
            for (BusinessTxnConfig config : configs.values()) {
                if (config.getFilter() == null || config.getFilter().getInclusions() == null) continue;
                if (this.msgLog.isTraceEnabled()) {
                    this.msgLog.trace("Remove unbound URIs associated with btxn config=" + config);
                }
                for (String filter : config.getFilter().getInclusions()) {
                    if (filter == null || filter.trim().length() <= 0) continue;
                    Iterator iter = ret.iterator();
                    while (iter.hasNext()) {
                        URIInfo info = (URIInfo)iter.next();
                        if (!Pattern.matches(filter, info.getUri())) continue;
                        iter.remove();
                    }
                }
            }
        }
        if (compress) {
            ret = AnalyticsServiceElasticsearch.compressURIInfo(ret);
        }
        Collections.sort(ret, new Comparator<URIInfo>(){

            @Override
            public int compare(URIInfo arg0, URIInfo arg1) {
                return arg0.getUri().compareTo(arg1.getUri());
            }
        });
        return ret;
    }

    protected void obtainProducerURIs(List<Node> nodes, List<URIInfo> uris, Map<String, URIInfo> map) {
        for (int i = 0; i < nodes.size(); ++i) {
            String uri;
            Node node = nodes.get(i);
            if (node instanceof Producer && !map.containsKey(uri = node.getUri())) {
                URIInfo info = new URIInfo();
                info.setUri(uri);
                info.setEndpointType(((Producer)node).getEndpointType());
                uris.add(info);
                map.put(uri, info);
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainProducerURIs(((ContainerNode)node).getNodes(), uris, map);
        }
    }

    public List<String> getBoundURIs(String tenantId, String businessTransaction, long startTime, long endTime) {
        ArrayList<String> ret = new ArrayList<String>();
        BusinessTransactionCriteria criteria = new BusinessTransactionCriteria();
        criteria.setBusinessTransaction(businessTransaction).setStartTime(startTime).setEndTime(endTime);
        List<BusinessTransaction> fragments = BusinessTransactionServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            this.obtainURIs(btxn.getNodes(), ret);
        }
        return ret;
    }

    protected void obtainURIs(List<Node> nodes, List<String> uris) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (node.getUri() != null && !uris.contains(node.getUri())) {
                uris.add(node.getUri());
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainURIs(((ContainerNode)node).getNodes(), uris);
        }
    }

    public List<PropertyInfo> getPropertyInfo(String tenantId, String businessTransaction, long startTime, long endTime) {
        ArrayList<PropertyInfo> ret = new ArrayList<PropertyInfo>();
        ArrayList<String> propertyNames = new ArrayList<String>();
        BusinessTransactionCriteria criteria = new BusinessTransactionCriteria();
        criteria.setStartTime(startTime).setEndTime(endTime).setBusinessTransaction(businessTransaction);
        List<BusinessTransaction> fragments = BusinessTransactionServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            BusinessTransaction btxn = fragments.get(i);
            for (String property : btxn.getProperties().keySet()) {
                if (propertyNames.contains(property)) continue;
                propertyNames.add(property);
                PropertyInfo pi = new PropertyInfo();
                pi.setName(property);
                ret.add(pi);
            }
        }
        Collections.sort(ret, new Comparator<PropertyInfo>(){

            @Override
            public int compare(PropertyInfo arg0, PropertyInfo arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return ret;
    }

    public long getCompletionCount(String tenantId, CompletionTimeCriteria criteria) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
            return 0L;
        }
        return response.getHits().getTotalHits();
    }

    public long getCompletionFaultCount(String tenantId, CompletionTimeCriteria criteria) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        ExistsFilterBuilder filter = FilterBuilders.existsFilter((String)"fault");
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query).setPostFilter((FilterBuilder)filter);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
            return 0L;
        }
        return response.getHits().getTotalHits();
    }

    public Percentiles getCompletionPercentiles(String tenantId, CompletionTimeCriteria criteria) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        PercentilesBuilder percentileAgg = (PercentilesBuilder)AggregationBuilders.percentiles((String)"percentiles").field("duration");
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)percentileAgg).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        Percentiles percentiles = new Percentiles();
        org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles agg = (org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles)response.getAggregations().get("percentiles");
        for (Percentile entry : agg) {
            percentiles.addPercentile((int)entry.getPercent(), entry.getValue());
        }
        return percentiles;
    }

    public List<CompletionTimeseriesStatistics> getCompletionTimeseriesStatistics(String tenantId, CompletionTimeCriteria criteria, long interval) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        StatsBuilder statsBuilder = (StatsBuilder)AggregationBuilders.stats((String)"stats").field("duration");
        MissingBuilder faultCountBuilder = AggregationBuilders.missing((String)"faults").field("fault");
        DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)statsBuilder)).subAggregation((AbstractAggregationBuilder)faultCountBuilder);
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)histogramBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        ArrayList<CompletionTimeseriesStatistics> stats = new ArrayList<CompletionTimeseriesStatistics>();
        DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
        for (DateHistogram.Bucket bucket : histogram.getBuckets()) {
            Stats stat = (Stats)bucket.getAggregations().get("stats");
            Missing missing = (Missing)bucket.getAggregations().get("faults");
            CompletionTimeseriesStatistics s = new CompletionTimeseriesStatistics();
            s.setTimestamp(bucket.getKeyAsDate().getMillis());
            s.setAverage(stat.getAvg());
            s.setMin(stat.getMin());
            s.setMax(stat.getMax());
            s.setCount(stat.getCount());
            s.setFaultCount(stat.getCount() - missing.getDocCount());
            stats.add(s);
        }
        return stats;
    }

    public List<Cardinality> getCompletionFaultDetails(String tenantId, CompletionTimeCriteria criteria) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("fault")).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)cardinalityBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        ArrayList<Cardinality> ret = new ArrayList<Cardinality>();
        Terms terms = (Terms)response.getAggregations().get("cardinality");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            Cardinality card = new Cardinality();
            card.setValue(bucket.getKey());
            card.setCount(bucket.getDocCount());
            ret.add(card);
        }
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return (int)(arg1.getCount() - arg0.getCount());
            }
        });
        return ret;
    }

    public List<Cardinality> getCompletionPropertyDetails(String tenantId, CompletionTimeCriteria criteria, String property) {
        if (criteria.getBusinessTransaction() == null) {
            throw new IllegalArgumentException("Business transaction name not specified");
        }
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        TermsBuilder cardinalityBuilder = ((TermsBuilder)AggregationBuilders.terms((String)"cardinality").field("properties." + property)).order(Terms.Order.aggregation((String)"_count", (boolean)false)).size(criteria.getMaxResponseSize());
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{COMPLETION_TIME_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)cardinalityBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        ArrayList<Cardinality> ret = new ArrayList<Cardinality>();
        Terms terms = (Terms)response.getAggregations().get("cardinality");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            Cardinality card = new Cardinality();
            card.setValue(bucket.getKey());
            card.setCount(bucket.getDocCount());
            ret.add(card);
        }
        Collections.sort(ret, new Comparator<Cardinality>(){

            @Override
            public int compare(Cardinality arg0, Cardinality arg1) {
                return arg0.getValue().compareTo(arg1.getValue());
            }
        });
        return ret;
    }

    public int getAlertCount(String tenantId, String name) {
        return 0;
    }

    public List<NodeTimeseriesStatistics> getNodeTimeseriesStatistics(String tenantId, NodeCriteria criteria, long interval) {
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        AvgBuilder avgBuilder = (AvgBuilder)AggregationBuilders.avg((String)"avg").field("actual");
        TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)avgBuilder);
        DateHistogramBuilder histogramBuilder = (DateHistogramBuilder)((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"histogram").interval(interval).field("timestamp")).subAggregation((AbstractAggregationBuilder)componentsBuilder);
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{NODE_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)histogramBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        ArrayList<NodeTimeseriesStatistics> stats = new ArrayList<NodeTimeseriesStatistics>();
        DateHistogram histogram = (DateHistogram)response.getAggregations().get("histogram");
        for (DateHistogram.Bucket bucket : histogram.getBuckets()) {
            Terms term = (Terms)bucket.getAggregations().get("components");
            NodeTimeseriesStatistics s = new NodeTimeseriesStatistics();
            s.setTimestamp(bucket.getKeyAsDate().getMillis());
            for (Terms.Bucket termBucket : term.getBuckets()) {
                Avg avg = (Avg)termBucket.getAggregations().get("avg");
                s.getNodeDurations().put(termBucket.getKey(), avg.getValue());
            }
            stats.add(s);
        }
        return stats;
    }

    public List<NodeSummaryStatistics> getNodeSummaryStatistics(String tenantId, NodeCriteria criteria) {
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "timestamp", "businessTransaction");
        AvgBuilder actualBuilder = (AvgBuilder)AggregationBuilders.avg((String)"actual").field("actual");
        AvgBuilder elapsedBuilder = (AvgBuilder)AggregationBuilders.avg((String)"elapsed").field("elapsed");
        TermsBuilder operationsBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"operations").field("operation")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
        MissingBuilder missingOperationBuilder = (MissingBuilder)((MissingBuilder)AggregationBuilders.missing((String)"missingOperation").field("operation").subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
        TermsBuilder urisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)operationsBuilder)).subAggregation((AbstractAggregationBuilder)missingOperationBuilder);
        TermsBuilder componentsBuilder = (TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"components").field("componentType")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)urisBuilder);
        TermsBuilder interactionUrisBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"uris").field("uri")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)actualBuilder)).subAggregation((AbstractAggregationBuilder)elapsedBuilder);
        MissingBuilder missingComponentsBuilder = (MissingBuilder)AggregationBuilders.missing((String)"missingcomponent").field("componentType").subAggregation((AbstractAggregationBuilder)interactionUrisBuilder);
        TermsBuilder nodesBuilder = (TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"types").field("type")).size(criteria.getMaxResponseSize()).subAggregation((AbstractAggregationBuilder)componentsBuilder)).subAggregation((AbstractAggregationBuilder)missingComponentsBuilder);
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{NODE_DETAILS_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).addAggregation((AbstractAggregationBuilder)nodesBuilder).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        ArrayList<NodeSummaryStatistics> stats = new ArrayList<NodeSummaryStatistics>();
        Terms types = (Terms)response.getAggregations().get("types");
        for (Terms.Bucket typeBucket : types.getBuckets()) {
            Terms components = (Terms)typeBucket.getAggregations().get("components");
            for (Terms.Bucket componentBucket : components.getBuckets()) {
                Terms uris = (Terms)componentBucket.getAggregations().get("uris");
                for (Terms.Bucket uriBucket : uris.getBuckets()) {
                    Terms operations = (Terms)uriBucket.getAggregations().get("operations");
                    for (Terms.Bucket operationBucket : operations.getBuckets()) {
                        Avg actual = (Avg)operationBucket.getAggregations().get("actual");
                        Avg elapsed = (Avg)operationBucket.getAggregations().get("elapsed");
                        NodeSummaryStatistics stat = new NodeSummaryStatistics();
                        if (typeBucket.getKey().equalsIgnoreCase("consumer")) {
                            stat.setComponentType("consumer");
                        } else if (typeBucket.getKey().equalsIgnoreCase("producer")) {
                            stat.setComponentType("producer");
                        } else {
                            stat.setComponentType(componentBucket.getKey());
                        }
                        stat.setUri(uriBucket.getKey());
                        stat.setOperation(operationBucket.getKey());
                        stat.setActual(actual.getValue());
                        stat.setElapsed(elapsed.getValue());
                        stat.setCount(operationBucket.getDocCount());
                        stats.add(stat);
                    }
                    Missing missingOp = (Missing)uriBucket.getAggregations().get("missingOperation");
                    Avg actual = (Avg)missingOp.getAggregations().get("actual");
                    Avg elapsed = (Avg)missingOp.getAggregations().get("elapsed");
                    if (actual.getValueAsString().equals("NaN")) continue;
                    NodeSummaryStatistics stat = new NodeSummaryStatistics();
                    if (typeBucket.getKey().equalsIgnoreCase("consumer")) {
                        stat.setComponentType("consumer");
                    } else if (typeBucket.getKey().equalsIgnoreCase("producer")) {
                        stat.setComponentType("producer");
                    } else {
                        stat.setComponentType(componentBucket.getKey());
                    }
                    stat.setUri(uriBucket.getKey());
                    stat.setActual(actual.getValue());
                    stat.setElapsed(elapsed.getValue());
                    stat.setCount(missingOp.getDocCount());
                    stats.add(stat);
                }
            }
            Missing missingComponents = (Missing)typeBucket.getAggregations().get("missingcomponent");
            Terms uris = (Terms)missingComponents.getAggregations().get("uris");
            for (Terms.Bucket uriBucket : uris.getBuckets()) {
                Avg actual = (Avg)uriBucket.getAggregations().get("actual");
                Avg elapsed = (Avg)uriBucket.getAggregations().get("elapsed");
                NodeSummaryStatistics stat = new NodeSummaryStatistics();
                stat.setComponentType(typeBucket.getKey());
                stat.setUri(uriBucket.getKey());
                stat.setActual(actual.getValue());
                stat.setElapsed(elapsed.getValue());
                stat.setCount(uriBucket.getDocCount());
                stats.add(stat);
            }
        }
        return stats;
    }

    public void storeNodeDetails(String tenantId, List<NodeDetails> nodeDetails) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < nodeDetails.size(); ++i) {
            NodeDetails rt = nodeDetails.get(i);
            String json = mapper.writeValueAsString((Object)rt);
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Storing node details: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), NODE_DETAILS_TYPE, rt.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store node details: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store node details to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing node details to elasticsearch");
        }
    }

    public void storeCompletionTimes(String tenantId, List<CompletionTime> completionTimes) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < completionTimes.size(); ++i) {
            CompletionTime ct = completionTimes.get(i);
            String json = mapper.writeValueAsString((Object)ct);
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Storing completion time: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), COMPLETION_TIME_TYPE, ct.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            this.msgLog.error("Failed to store completion times: " + bulkItemResponses.buildFailureMessage());
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.trace("Failed to store completion times to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (this.msgLog.isTraceEnabled()) {
            this.msgLog.trace("Success storing completion times to elasticsearch");
        }
    }

    public List<String> getHostNames(String tenantId, BaseCriteria criteria) {
        ArrayList<String> ret = new ArrayList<String>();
        String index = this.client.getIndex(tenantId);
        RefreshRequestBuilder refreshRequestBuilder = this.client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
        this.client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
        BoolQueryBuilder query = ElasticsearchUtil.buildQuery(criteria, "startTime", "name");
        SearchRequestBuilder request = this.client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{"businesstransaction"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
        SearchResponse response = (SearchResponse)request.execute().actionGet();
        if (response.isTimedOut()) {
            this.msgLog.warnQueryTimedOut();
        }
        ArrayList<Object> btxns = new ArrayList<Object>();
        for (SearchHit searchHitFields : response.getHits()) {
            try {
                btxns.add(mapper.readValue(searchHitFields.getSourceAsString(), BusinessTransaction.class));
            }
            catch (Exception e) {
                this.msgLog.errorFailedToParse(e);
            }
        }
        for (int i = 0; i < btxns.size(); ++i) {
            BusinessTransaction btxn = (BusinessTransaction)btxns.get(i);
            if (btxn.getHostName() == null || btxn.getHostName().trim().length() == 0 || ret.contains(btxn.getHostName())) continue;
            ret.add(btxn.getHostName());
        }
        Collections.sort(ret);
        return ret;
    }

    protected void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
    }
}

