/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BaseCriteria;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.btm.server.elasticsearch.ElasticsearchUtil;
import org.hawkular.btm.server.elasticsearch.log.MsgLogger;

public class BusinessTransactionServiceElasticsearch
implements BusinessTransactionService {
    private static final MsgLogger msgLog = MsgLogger.LOGGER;
    public static final String BUSINESS_TRANSACTION_TYPE = "businesstransaction";
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    private ElasticsearchClient client;

    protected ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    protected void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    public BusinessTransaction get(String tenantId, String id) {
        BusinessTransaction ret = null;
        GetResponse response = (GetResponse)this.client.getElasticsearchClient().prepareGet(this.client.getIndex(tenantId), BUSINESS_TRANSACTION_TYPE, id).setRouting(id).execute().actionGet();
        if (!response.isSourceEmpty()) {
            try {
                ret = (BusinessTransaction)mapper.readValue(response.getSourceAsString(), BusinessTransaction.class);
            }
            catch (Exception e) {
                msgLog.errorFailedToParse(e);
            }
        }
        if (msgLog.isTraceEnabled()) {
            msgLog.tracef("Get business transaction with id[%s] is: %s", id, ret);
        }
        return ret;
    }

    public List<BusinessTransaction> query(String tenantId, BusinessTransactionCriteria criteria) {
        return BusinessTransactionServiceElasticsearch.internalQuery(this.client, tenantId, criteria);
    }

    protected static List<BusinessTransaction> internalQuery(ElasticsearchClient client, String tenantId, BusinessTransactionCriteria criteria) {
        ArrayList<BusinessTransaction> ret;
        block8: {
            ret = new ArrayList<BusinessTransaction>();
            String index = client.getIndex(tenantId);
            try {
                SearchResponse response;
                RefreshRequestBuilder refreshRequestBuilder = client.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                client.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                BoolQueryBuilder query = ElasticsearchUtil.buildQuery((BaseCriteria)criteria, "startTime", "name");
                SearchRequestBuilder request = client.getElasticsearchClient().prepareSearch(new String[]{index}).setTypes(new String[]{BUSINESS_TRANSACTION_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)criteria.getTimeout())).setSize(criteria.getMaxResponseSize()).setQuery((QueryBuilder)query);
                FilterBuilder filter = ElasticsearchUtil.buildFilter(criteria);
                if (filter != null) {
                    request.setPostFilter(filter);
                }
                if ((response = (SearchResponse)request.execute().actionGet()).isTimedOut()) {
                    msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        ret.add((BusinessTransaction)mapper.readValue(searchHitFields.getSourceAsString(), BusinessTransaction.class));
                    }
                    catch (Exception e) {
                        msgLog.errorFailedToParse(e);
                    }
                }
                if (msgLog.isTraceEnabled()) {
                    msgLog.tracef("Query business transactions with criteria[%s] is: %s", criteria, ret);
                }
            }
            catch (IndexMissingException t) {
                if (!msgLog.isTraceEnabled()) break block8;
                msgLog.tracef("No index found, so unable to retrieve business transactions", new Object[0]);
            }
        }
        return ret;
    }

    public void storeBusinessTransactions(String tenantId, List<BusinessTransaction> businessTransactions) throws Exception {
        this.client.initTenant(tenantId);
        BulkRequestBuilder bulkRequestBuilder = this.client.getElasticsearchClient().prepareBulk();
        for (int i = 0; i < businessTransactions.size(); ++i) {
            BusinessTransaction btxn = businessTransactions.get(i);
            String json = mapper.writeValueAsString((Object)btxn);
            if (msgLog.isTraceEnabled()) {
                msgLog.tracef("Storing business transaction: %s", json);
            }
            bulkRequestBuilder.add(this.client.getElasticsearchClient().prepareIndex(this.client.getIndex(tenantId), BUSINESS_TRANSACTION_TYPE, btxn.getId()).setSource(json));
        }
        BulkResponse bulkItemResponses = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (bulkItemResponses.hasFailures()) {
            msgLog.error("Failed to store business transactions: " + bulkItemResponses.buildFailureMessage());
            if (msgLog.isTraceEnabled()) {
                msgLog.trace("Failed to store business transactions to elasticsearch: " + bulkItemResponses.buildFailureMessage());
            }
        } else if (msgLog.isTraceEnabled()) {
            msgLog.trace("Success storing business transactions to elasticsearch");
        }
    }

    protected void clear(String tenantId) {
        String index = this.client.getIndex(tenantId);
        this.client.getElasticsearchClient().admin().indices().prepareDelete(new String[]{index}).execute().actionGet();
    }
}

